<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatMapResponses StructType
 * Meta informations extracted from the WSDL
 * - documentation: Seat map response element containing the results of the request
 * @subpackage Structs
 */
class SeatMapResponses extends AbstractStructBase
{
    /**
     * The SeatMapResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\SeatMapResponse[]
     */
    public $SeatMapResponse;
    /**
     * The AirTravelers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AirTravelers
     */
    public $AirTravelers;
    /**
     * Constructor method for SeatMapResponses
     * @uses SeatMapResponses::setSeatMapResponse()
     * @uses SeatMapResponses::setAirTravelers()
     * @param \StructType\SeatMapResponse[] $seatMapResponse
     * @param \StructType\AirTravelers $airTravelers
     */
    public function __construct(array $seatMapResponse = array(), \StructType\AirTravelers $airTravelers = null)
    {
        $this
            ->setSeatMapResponse($seatMapResponse)
            ->setAirTravelers($airTravelers);
    }
    /**
     * Get SeatMapResponse value
     * @return \StructType\SeatMapResponse[]|null
     */
    public function getSeatMapResponse()
    {
        return $this->SeatMapResponse;
    }
    /**
     * Set SeatMapResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatMapResponse[] $seatMapResponse
     * @return \StructType\SeatMapResponses
     */
    public function setSeatMapResponse(array $seatMapResponse = array())
    {
        foreach ($seatMapResponse as $seatMapResponsesSeatMapResponseItem) {
            // validation for constraint: itemType
            if (!$seatMapResponsesSeatMapResponseItem instanceof \StructType\SeatMapResponse) {
                throw new \InvalidArgumentException(sprintf('The SeatMapResponse property can only contain items of \StructType\SeatMapResponse, "%s" given', is_object($seatMapResponsesSeatMapResponseItem) ? get_class($seatMapResponsesSeatMapResponseItem) : gettype($seatMapResponsesSeatMapResponseItem)), __LINE__);
            }
        }
        $this->SeatMapResponse = $seatMapResponse;
        return $this;
    }
    /**
     * Add item to SeatMapResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatMapResponse $item
     * @return \StructType\SeatMapResponses
     */
    public function addToSeatMapResponse(\StructType\SeatMapResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatMapResponse) {
            throw new \InvalidArgumentException(sprintf('The SeatMapResponse property can only contain items of \StructType\SeatMapResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SeatMapResponse[] = $item;
        return $this;
    }
    /**
     * Get AirTravelers value
     * @return \StructType\AirTravelers|null
     */
    public function getAirTravelers()
    {
        return $this->AirTravelers;
    }
    /**
     * Set AirTravelers value
     * @param \StructType\AirTravelers $airTravelers
     * @return \StructType\SeatMapResponses
     */
    public function setAirTravelers(\StructType\AirTravelers $airTravelers = null)
    {
        $this->AirTravelers = $airTravelers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatMapResponses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
