<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatMapResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: One SeatMapResponse element is returned for each of the flight segment requested in the input request.
 * @subpackage Structs
 */
class SeatMapResponse extends AbstractStructBase
{
    /**
     * The FlightSegmentInfo
     * @var \StructType\FlightSegmentInfo
     */
    public $FlightSegmentInfo;
    /**
     * The SeatMapDetails
     * Meta informations extracted from the WSDL
     * - documentation: This identifies the seat map details for the flight segment in the corresponding 'FlightSegmentInfo' element. If the responding system has different seat maps for different passengers for the same flight segment then this element
     * will reccur accordingly. The availability of seats can differ based upon various conditions, such as a passenger's status within a loyalty program or by the amount paid or class of service booked for the ticket. For example, if one passenger has a
     * certain status in the Frequent Flyer program of the airline, certain desirable seats may be available for selection. A passenger without such status may not be able to select those seats. Thus the availability of seats can differ by passenger.
     * - maxOccurs: 99
     * @var \StructType\SeatMapDetailsType[]
     */
    public $SeatMapDetails;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: This is used for PNR record locator. If there are more than one PNR numbers because of muliple airlines in the itinerary then this element could be repeated.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $BookingReferenceID;
    /**
     * The SeatUpgradeApplied
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: This indicates if the respone has the Seat Map upgrade applied
     * @var bool
     */
    public $SeatUpgradeApplied;
    /**
     * Constructor method for SeatMapResponse
     * @uses SeatMapResponse::setFlightSegmentInfo()
     * @uses SeatMapResponse::setSeatMapDetails()
     * @uses SeatMapResponse::setBookingReferenceID()
     * @uses SeatMapResponse::setSeatUpgradeApplied()
     * @param \StructType\FlightSegmentInfo $flightSegmentInfo
     * @param \StructType\SeatMapDetailsType[] $seatMapDetails
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     * @param bool $seatUpgradeApplied
     */
    public function __construct(\StructType\FlightSegmentInfo $flightSegmentInfo = null, array $seatMapDetails = array(), array $bookingReferenceID = array(), $seatUpgradeApplied = false)
    {
        $this
            ->setFlightSegmentInfo($flightSegmentInfo)
            ->setSeatMapDetails($seatMapDetails)
            ->setBookingReferenceID($bookingReferenceID)
            ->setSeatUpgradeApplied($seatUpgradeApplied);
    }
    /**
     * Get FlightSegmentInfo value
     * @return \StructType\FlightSegmentInfo|null
     */
    public function getFlightSegmentInfo()
    {
        return $this->FlightSegmentInfo;
    }
    /**
     * Set FlightSegmentInfo value
     * @param \StructType\FlightSegmentInfo $flightSegmentInfo
     * @return \StructType\SeatMapResponse
     */
    public function setFlightSegmentInfo(\StructType\FlightSegmentInfo $flightSegmentInfo = null)
    {
        $this->FlightSegmentInfo = $flightSegmentInfo;
        return $this;
    }
    /**
     * Get SeatMapDetails value
     * @return \StructType\SeatMapDetailsType[]|null
     */
    public function getSeatMapDetails()
    {
        return $this->SeatMapDetails;
    }
    /**
     * Set SeatMapDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatMapDetailsType[] $seatMapDetails
     * @return \StructType\SeatMapResponse
     */
    public function setSeatMapDetails(array $seatMapDetails = array())
    {
        foreach ($seatMapDetails as $seatMapResponseSeatMapDetailsItem) {
            // validation for constraint: itemType
            if (!$seatMapResponseSeatMapDetailsItem instanceof \StructType\SeatMapDetailsType) {
                throw new \InvalidArgumentException(sprintf('The SeatMapDetails property can only contain items of \StructType\SeatMapDetailsType, "%s" given', is_object($seatMapResponseSeatMapDetailsItem) ? get_class($seatMapResponseSeatMapDetailsItem) : gettype($seatMapResponseSeatMapDetailsItem)), __LINE__);
            }
        }
        $this->SeatMapDetails = $seatMapDetails;
        return $this;
    }
    /**
     * Add item to SeatMapDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatMapDetailsType $item
     * @return \StructType\SeatMapResponse
     */
    public function addToSeatMapDetails(\StructType\SeatMapDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatMapDetailsType) {
            throw new \InvalidArgumentException(sprintf('The SeatMapDetails property can only contain items of \StructType\SeatMapDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SeatMapDetails[] = $item;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     * @return \StructType\SeatMapResponse
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        foreach ($bookingReferenceID as $seatMapResponseBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$seatMapResponseBookingReferenceIDItem instanceof \StructType\UniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($seatMapResponseBookingReferenceIDItem) ? get_class($seatMapResponseBookingReferenceIDItem) : gettype($seatMapResponseBookingReferenceIDItem)), __LINE__);
            }
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\SeatMapResponse
     */
    public function addToBookingReferenceID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Get SeatUpgradeApplied value
     * @return bool|null
     */
    public function getSeatUpgradeApplied()
    {
        return $this->SeatUpgradeApplied;
    }
    /**
     * Set SeatUpgradeApplied value
     * @param bool $seatUpgradeApplied
     * @return \StructType\SeatMapResponse
     */
    public function setSeatUpgradeApplied($seatUpgradeApplied = false)
    {
        // validation for constraint: boolean
        if (!is_null($seatUpgradeApplied) && !is_bool($seatUpgradeApplied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($seatUpgradeApplied)), __LINE__);
        }
        $this->SeatUpgradeApplied = $seatUpgradeApplied;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatMapResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
