<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SSRDetailsResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: One ssrDetailsResponse element is returned for each of the flight segment requested in the input request.
 * @subpackage Structs
 */
class SSRDetailsResponse extends AbstractStructBase
{
    /**
     * The FlightSegmentInfo
     * @var \StructType\FlightSegmentInfo
     */
    public $FlightSegmentInfo;
    /**
     * The AirportService
     * Meta informations extracted from the WSDL
     * - documentation: This identifies the Airport Service details for the flight segment in the corresponding 'FlightSegmentInfo' element.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\AirportService[]
     */
    public $AirportService;
    /**
     * The InflightService
     * Meta informations extracted from the WSDL
     * - documentation: This identifies the In-flight Service details for the flight segment in the corresponding 'FlightSegmentInfo' element.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\InflightService[]
     */
    public $InflightService;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: This is used for PNR record locator. If there are more than one PNR numbers because of muliple airlines in the itinerary then this element could be repeated.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $BookingReferenceID;
    /**
     * The AirportCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AirportCode;
    /**
     * The AirportType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AirportType;
    /**
     * Constructor method for SSRDetailsResponse
     * @uses SSRDetailsResponse::setFlightSegmentInfo()
     * @uses SSRDetailsResponse::setAirportService()
     * @uses SSRDetailsResponse::setInflightService()
     * @uses SSRDetailsResponse::setBookingReferenceID()
     * @uses SSRDetailsResponse::setAirportCode()
     * @uses SSRDetailsResponse::setAirportType()
     * @param \StructType\FlightSegmentInfo $flightSegmentInfo
     * @param \StructType\AirportService[] $airportService
     * @param \StructType\InflightService[] $inflightService
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     * @param string $airportCode
     * @param string $airportType
     */
    public function __construct(\StructType\FlightSegmentInfo $flightSegmentInfo = null, array $airportService = array(), array $inflightService = array(), array $bookingReferenceID = array(), $airportCode = null, $airportType = null)
    {
        $this
            ->setFlightSegmentInfo($flightSegmentInfo)
            ->setAirportService($airportService)
            ->setInflightService($inflightService)
            ->setBookingReferenceID($bookingReferenceID)
            ->setAirportCode($airportCode)
            ->setAirportType($airportType);
    }
    /**
     * Get FlightSegmentInfo value
     * @return \StructType\FlightSegmentInfo|null
     */
    public function getFlightSegmentInfo()
    {
        return $this->FlightSegmentInfo;
    }
    /**
     * Set FlightSegmentInfo value
     * @param \StructType\FlightSegmentInfo $flightSegmentInfo
     * @return \StructType\SSRDetailsResponse
     */
    public function setFlightSegmentInfo(\StructType\FlightSegmentInfo $flightSegmentInfo = null)
    {
        $this->FlightSegmentInfo = $flightSegmentInfo;
        return $this;
    }
    /**
     * Get AirportService value
     * @return \StructType\AirportService[]|null
     */
    public function getAirportService()
    {
        return $this->AirportService;
    }
    /**
     * Set AirportService value
     * @throws \InvalidArgumentException
     * @param \StructType\AirportService[] $airportService
     * @return \StructType\SSRDetailsResponse
     */
    public function setAirportService(array $airportService = array())
    {
        foreach ($airportService as $sSRDetailsResponseAirportServiceItem) {
            // validation for constraint: itemType
            if (!$sSRDetailsResponseAirportServiceItem instanceof \StructType\AirportService) {
                throw new \InvalidArgumentException(sprintf('The AirportService property can only contain items of \StructType\AirportService, "%s" given', is_object($sSRDetailsResponseAirportServiceItem) ? get_class($sSRDetailsResponseAirportServiceItem) : gettype($sSRDetailsResponseAirportServiceItem)), __LINE__);
            }
        }
        $this->AirportService = $airportService;
        return $this;
    }
    /**
     * Add item to AirportService value
     * @throws \InvalidArgumentException
     * @param \StructType\AirportService $item
     * @return \StructType\SSRDetailsResponse
     */
    public function addToAirportService(\StructType\AirportService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirportService) {
            throw new \InvalidArgumentException(sprintf('The AirportService property can only contain items of \StructType\AirportService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirportService[] = $item;
        return $this;
    }
    /**
     * Get InflightService value
     * @return \StructType\InflightService[]|null
     */
    public function getInflightService()
    {
        return $this->InflightService;
    }
    /**
     * Set InflightService value
     * @throws \InvalidArgumentException
     * @param \StructType\InflightService[] $inflightService
     * @return \StructType\SSRDetailsResponse
     */
    public function setInflightService(array $inflightService = array())
    {
        foreach ($inflightService as $sSRDetailsResponseInflightServiceItem) {
            // validation for constraint: itemType
            if (!$sSRDetailsResponseInflightServiceItem instanceof \StructType\InflightService) {
                throw new \InvalidArgumentException(sprintf('The InflightService property can only contain items of \StructType\InflightService, "%s" given', is_object($sSRDetailsResponseInflightServiceItem) ? get_class($sSRDetailsResponseInflightServiceItem) : gettype($sSRDetailsResponseInflightServiceItem)), __LINE__);
            }
        }
        $this->InflightService = $inflightService;
        return $this;
    }
    /**
     * Add item to InflightService value
     * @throws \InvalidArgumentException
     * @param \StructType\InflightService $item
     * @return \StructType\SSRDetailsResponse
     */
    public function addToInflightService(\StructType\InflightService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InflightService) {
            throw new \InvalidArgumentException(sprintf('The InflightService property can only contain items of \StructType\InflightService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InflightService[] = $item;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     * @return \StructType\SSRDetailsResponse
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        foreach ($bookingReferenceID as $sSRDetailsResponseBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$sSRDetailsResponseBookingReferenceIDItem instanceof \StructType\UniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($sSRDetailsResponseBookingReferenceIDItem) ? get_class($sSRDetailsResponseBookingReferenceIDItem) : gettype($sSRDetailsResponseBookingReferenceIDItem)), __LINE__);
            }
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\SSRDetailsResponse
     */
    public function addToBookingReferenceID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \StructType\SSRDetailsResponse
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airportCode)), __LINE__);
        }
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get AirportType value
     * @return string|null
     */
    public function getAirportType()
    {
        return $this->AirportType;
    }
    /**
     * Set AirportType value
     * @param string $airportType
     * @return \StructType\SSRDetailsResponse
     */
    public function setAirportType($airportType = null)
    {
        // validation for constraint: string
        if (!is_null($airportType) && !is_string($airportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airportType)), __LINE__);
        }
        $this->AirportType = $airportType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SSRDetailsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
