<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuoteDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains the information about the plan, such as the name of the insurance company and restrictions, specific to the quote.
 * @subpackage Structs
 */
class QuoteDetail extends AbstractStructBase
{
    /**
     * The ProviderCompany
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the company providing the insurance product quoted in this response message.
     * @var \StructType\CompanyNameType
     */
    public $ProviderCompany;
    /**
     * The QuoteDetailURL
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the location of a file containing specific details regarding this quote.
     * - minOccurs: 0
     * @var \StructType\URL_Type
     */
    public $QuoteDetailURL;
    /**
     * The PlanRestrictions
     * Meta informations extracted from the WSDL
     * - documentation: Container for any restrictions to coverage of the quoted plan.
     * - minOccurs: 0
     * @var \StructType\PlanRestrictionType
     */
    public $PlanRestrictions;
    /**
     * The BookingDetailURL
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the location of a file containing booking details
     * - minOccurs: 0
     * @var \StructType\URL_Type
     */
    public $BookingDetailURL;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for QuoteDetail
     * @uses QuoteDetail::setProviderCompany()
     * @uses QuoteDetail::setQuoteDetailURL()
     * @uses QuoteDetail::setPlanRestrictions()
     * @uses QuoteDetail::setBookingDetailURL()
     * @uses QuoteDetail::setEffectiveDate()
     * @uses QuoteDetail::setExpireDate()
     * @param \StructType\CompanyNameType $providerCompany
     * @param \StructType\URL_Type $quoteDetailURL
     * @param \StructType\PlanRestrictionType $planRestrictions
     * @param \StructType\URL_Type $bookingDetailURL
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct(\StructType\CompanyNameType $providerCompany = null, \StructType\URL_Type $quoteDetailURL = null, \StructType\PlanRestrictionType $planRestrictions = null, \StructType\URL_Type $bookingDetailURL = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setProviderCompany($providerCompany)
            ->setQuoteDetailURL($quoteDetailURL)
            ->setPlanRestrictions($planRestrictions)
            ->setBookingDetailURL($bookingDetailURL)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get ProviderCompany value
     * @return \StructType\CompanyNameType|null
     */
    public function getProviderCompany()
    {
        return $this->ProviderCompany;
    }
    /**
     * Set ProviderCompany value
     * @param \StructType\CompanyNameType $providerCompany
     * @return \StructType\QuoteDetail
     */
    public function setProviderCompany(\StructType\CompanyNameType $providerCompany = null)
    {
        $this->ProviderCompany = $providerCompany;
        return $this;
    }
    /**
     * Get QuoteDetailURL value
     * @return \StructType\URL_Type|null
     */
    public function getQuoteDetailURL()
    {
        return $this->QuoteDetailURL;
    }
    /**
     * Set QuoteDetailURL value
     * @param \StructType\URL_Type $quoteDetailURL
     * @return \StructType\QuoteDetail
     */
    public function setQuoteDetailURL(\StructType\URL_Type $quoteDetailURL = null)
    {
        $this->QuoteDetailURL = $quoteDetailURL;
        return $this;
    }
    /**
     * Get PlanRestrictions value
     * @return \StructType\PlanRestrictionType|null
     */
    public function getPlanRestrictions()
    {
        return $this->PlanRestrictions;
    }
    /**
     * Set PlanRestrictions value
     * @param \StructType\PlanRestrictionType $planRestrictions
     * @return \StructType\QuoteDetail
     */
    public function setPlanRestrictions(\StructType\PlanRestrictionType $planRestrictions = null)
    {
        $this->PlanRestrictions = $planRestrictions;
        return $this;
    }
    /**
     * Get BookingDetailURL value
     * @return \StructType\URL_Type|null
     */
    public function getBookingDetailURL()
    {
        return $this->BookingDetailURL;
    }
    /**
     * Set BookingDetailURL value
     * @param \StructType\URL_Type $bookingDetailURL
     * @return \StructType\QuoteDetail
     */
    public function setBookingDetailURL(\StructType\URL_Type $bookingDetailURL = null)
    {
        $this->BookingDetailURL = $bookingDetailURL;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\QuoteDetail
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\QuoteDetail
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuoteDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
