<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItinerariesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for priced itineraries.
 * @subpackage Structs
 */
class PricedItinerariesType extends AbstractStructBase
{
    /**
     * The PricedItinerary
     * Meta informations extracted from the WSDL
     * - documentation: Itinerary with pricing information.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $PricedItinerary;
    /**
     * Constructor method for PricedItinerariesType
     * @uses PricedItinerariesType::setPricedItinerary()
     * @param mixed[] $pricedItinerary
     */
    public function __construct(array $pricedItinerary = array())
    {
        $this
            ->setPricedItinerary($pricedItinerary);
    }
    /**
     * Get PricedItinerary value
     * @return mixed[]|null
     */
    public function getPricedItinerary()
    {
        return $this->PricedItinerary;
    }
    /**
     * Set PricedItinerary value
     * @throws \InvalidArgumentException
     * @param mixed[] $pricedItinerary
     * @return \StructType\PricedItinerariesType
     */
    public function setPricedItinerary(array $pricedItinerary = array())
    {
        foreach ($pricedItinerary as $pricedItinerariesTypePricedItineraryItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The PricedItinerary property can only contain items of anyType, "%s" given', is_object($pricedItinerariesTypePricedItineraryItem) ? get_class($pricedItinerariesTypePricedItineraryItem) : gettype($pricedItinerariesTypePricedItineraryItem)), __LINE__);
            }
        }
        $this->PricedItinerary = $pricedItinerary;
        return $this;
    }
    /**
     * Add item to PricedItinerary value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PricedItinerariesType
     */
    public function addToPricedItinerary($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The PricedItinerary property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PricedItinerary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricedItinerariesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
