<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDetails StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for Payment Detail. | Container for payment detail
 * @subpackage Structs
 */
class PaymentDetails extends AbstractStructBase
{
    /**
     * The PaymentDetail
     * Meta informations extracted from the WSDL
     * - documentation: Form of payment details for the requested booking. It is possible to use multiple forms of payment for one transaction, therefore this element may be used more than once. | The form of payment that was specified in the booking
     * request message.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $PaymentDetail;
    /**
     * Constructor method for PaymentDetails
     * @uses PaymentDetails::setPaymentDetail()
     * @param mixed[] $paymentDetail
     */
    public function __construct(array $paymentDetail = array())
    {
        $this
            ->setPaymentDetail($paymentDetail);
    }
    /**
     * Get PaymentDetail value
     * @return mixed[]|null
     */
    public function getPaymentDetail()
    {
        return $this->PaymentDetail;
    }
    /**
     * Set PaymentDetail value
     * @throws \InvalidArgumentException
     * @param mixed[] $paymentDetail
     * @return \StructType\PaymentDetails
     */
    public function setPaymentDetail(array $paymentDetail = array())
    {
        foreach ($paymentDetail as $paymentDetailsPaymentDetailItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of anyType, "%s" given', is_object($paymentDetailsPaymentDetailItem) ? get_class($paymentDetailsPaymentDetailItem) : gettype($paymentDetailsPaymentDetailItem)), __LINE__);
            }
        }
        $this->PaymentDetail = $paymentDetail;
        return $this;
    }
    /**
     * Add item to PaymentDetail value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PaymentDetails
     */
    public function addToPaymentDetail($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
