<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PFSFlight StructType
 * @subpackage Structs
 */
class PFSFlight extends AbstractStructBase
{
    /**
     * The departureDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $departureDate;
    /**
     * The flightNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $flightNo;
    /**
     * The fromAirport
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromAirport;
    /**
     * Constructor method for PFSFlight
     * @uses PFSFlight::setDepartureDate()
     * @uses PFSFlight::setFlightNo()
     * @uses PFSFlight::setFromAirport()
     * @param string $departureDate
     * @param string $flightNo
     * @param string $fromAirport
     */
    public function __construct($departureDate = null, $flightNo = null, $fromAirport = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setFlightNo($flightNo)
            ->setFromAirport($fromAirport);
    }
    /**
     * Get departureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->departureDate;
    }
    /**
     * Set departureDate value
     * @param string $departureDate
     * @return \StructType\PFSFlight
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->departureDate = $departureDate;
        return $this;
    }
    /**
     * Get flightNo value
     * @return string|null
     */
    public function getFlightNo()
    {
        return $this->flightNo;
    }
    /**
     * Set flightNo value
     * @param string $flightNo
     * @return \StructType\PFSFlight
     */
    public function setFlightNo($flightNo = null)
    {
        // validation for constraint: string
        if (!is_null($flightNo) && !is_string($flightNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNo)), __LINE__);
        }
        $this->flightNo = $flightNo;
        return $this;
    }
    /**
     * Get fromAirport value
     * @return string|null
     */
    public function getFromAirport()
    {
        return $this->fromAirport;
    }
    /**
     * Set fromAirport value
     * @param string $fromAirport
     * @return \StructType\PFSFlight
     */
    public function setFromAirport($fromAirport = null)
    {
        // validation for constraint: string
        if (!is_null($fromAirport) && !is_string($fromAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromAirport)), __LINE__);
        }
        $this->fromAirport = $fromAirport;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PFSFlight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
