<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationOptions StructType
 * Meta informations extracted from the WSDL
 * - documentation: Candidate for potential removal, usage is not recommended. Deprecation Warning added in 2006A | Container for OriginDestinationOption. | Defines Origin and Destination information. | A container for origin destination option
 * information. | Origin and Destination location, and time information for the Air Schedule request. | Holds the collection of flight options for this origin-destination pair. There maybe limits imposed by individual supplier that are below the maximum
 * occurrences for this element. | A collection of OriginDestinationOption
 * @subpackage Structs
 */
class OriginDestinationOptions extends AbstractStructBase
{
    /**
     * The OriginDestinationOption
     * Meta informations extracted from the WSDL
     * - documentation: A container for OriginDestinationOptionType.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $OriginDestinationOption;
    /**
     * The AABundledServiceExt
     * Meta informations extracted from the WSDL
     * - documentation: Available bundled services for OnD
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AABundledServiceExt;
    /**
     * Constructor method for OriginDestinationOptions
     * @uses OriginDestinationOptions::setOriginDestinationOption()
     * @uses OriginDestinationOptions::setAABundledServiceExt()
     * @param mixed[] $originDestinationOption
     * @param mixed[] $aABundledServiceExt
     */
    public function __construct(array $originDestinationOption = array(), array $aABundledServiceExt = array())
    {
        $this
            ->setOriginDestinationOption($originDestinationOption)
            ->setAABundledServiceExt($aABundledServiceExt);
    }
    /**
     * Get OriginDestinationOption value
     * @return mixed[]|null
     */
    public function getOriginDestinationOption()
    {
        return $this->OriginDestinationOption;
    }
    /**
     * Set OriginDestinationOption value
     * @throws \InvalidArgumentException
     * @param mixed[] $originDestinationOption
     * @return \StructType\OriginDestinationOptions
     */
    public function setOriginDestinationOption(array $originDestinationOption = array())
    {
        foreach ($originDestinationOption as $originDestinationOptionsOriginDestinationOptionItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The OriginDestinationOption property can only contain items of anyType, "%s" given', is_object($originDestinationOptionsOriginDestinationOptionItem) ? get_class($originDestinationOptionsOriginDestinationOptionItem) : gettype($originDestinationOptionsOriginDestinationOptionItem)), __LINE__);
            }
        }
        $this->OriginDestinationOption = $originDestinationOption;
        return $this;
    }
    /**
     * Add item to OriginDestinationOption value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\OriginDestinationOptions
     */
    public function addToOriginDestinationOption($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The OriginDestinationOption property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OriginDestinationOption[] = $item;
        return $this;
    }
    /**
     * Get AABundledServiceExt value
     * @return mixed[]|null
     */
    public function getAABundledServiceExt()
    {
        return $this->AABundledServiceExt;
    }
    /**
     * Set AABundledServiceExt value
     * @throws \InvalidArgumentException
     * @param mixed[] $aABundledServiceExt
     * @return \StructType\OriginDestinationOptions
     */
    public function setAABundledServiceExt(array $aABundledServiceExt = array())
    {
        foreach ($aABundledServiceExt as $originDestinationOptionsAABundledServiceExtItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The AABundledServiceExt property can only contain items of anyType, "%s" given', is_object($originDestinationOptionsAABundledServiceExtItem) ? get_class($originDestinationOptionsAABundledServiceExtItem) : gettype($originDestinationOptionsAABundledServiceExtItem)), __LINE__);
            }
        }
        $this->AABundledServiceExt = $aABundledServiceExt;
        return $this;
    }
    /**
     * Add item to AABundledServiceExt value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\OriginDestinationOptions
     */
    public function addToAABundledServiceExt($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The AABundledServiceExt property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AABundledServiceExt[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginDestinationOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
