<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationInformationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Origin and Destination location, and time information for the request. Also includes the ability to specify a connection location for the search.
 * @subpackage Structs
 */
class OriginDestinationInformationType extends TravelDateTimeType
{
    /**
     * The OriginLocation
     * @var \StructType\OriginLocation
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var \StructType\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The ConnectionLocations
     * Meta informations extracted from the WSDL
     * - documentation: Travel Connection Location - for example, air uses the IATA 3 letter code.
     * - minOccurs: 0
     * @var mixed
     */
    public $ConnectionLocations;
    /**
     * The GroundSegmentAvailability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GroundSegmentAvailability;
    /**
     * Constructor method for OriginDestinationInformationType
     * @uses OriginDestinationInformationType::setOriginLocation()
     * @uses OriginDestinationInformationType::setDestinationLocation()
     * @uses OriginDestinationInformationType::setConnectionLocations()
     * @uses OriginDestinationInformationType::setGroundSegmentAvailability()
     * @param \StructType\OriginLocation $originLocation
     * @param \StructType\DestinationLocation $destinationLocation
     * @param mixed $connectionLocations
     * @param bool $groundSegmentAvailability
     */
    public function __construct(\StructType\OriginLocation $originLocation = null, \StructType\DestinationLocation $destinationLocation = null, $connectionLocations = null, $groundSegmentAvailability = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setConnectionLocations($connectionLocations)
            ->setGroundSegmentAvailability($groundSegmentAvailability);
    }
    /**
     * Get OriginLocation value
     * @return \StructType\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \StructType\OriginLocation $originLocation
     * @return \StructType\OriginDestinationInformationType
     */
    public function setOriginLocation(\StructType\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \StructType\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \StructType\DestinationLocation $destinationLocation
     * @return \StructType\OriginDestinationInformationType
     */
    public function setDestinationLocation(\StructType\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get ConnectionLocations value
     * @return mixed|null
     */
    public function getConnectionLocations()
    {
        return $this->ConnectionLocations;
    }
    /**
     * Set ConnectionLocations value
     * @param mixed $connectionLocations
     * @return \StructType\OriginDestinationInformationType
     */
    public function setConnectionLocations($connectionLocations = null)
    {
        $this->ConnectionLocations = $connectionLocations;
        return $this;
    }
    /**
     * Get GroundSegmentAvailability value
     * @return bool|null
     */
    public function getGroundSegmentAvailability()
    {
        return $this->GroundSegmentAvailability;
    }
    /**
     * Set GroundSegmentAvailability value
     * @param bool $groundSegmentAvailability
     * @return \StructType\OriginDestinationInformationType
     */
    public function setGroundSegmentAvailability($groundSegmentAvailability = null)
    {
        // validation for constraint: boolean
        if (!is_null($groundSegmentAvailability) && !is_bool($groundSegmentAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($groundSegmentAvailability)), __LINE__);
        }
        $this->GroundSegmentAvailability = $groundSegmentAvailability;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginDestinationInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
