<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Operators StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for any number of companies or organizations operating the trips, tours or cruises included in the traveler(s) journey
 * @subpackage Structs
 */
class Operators extends AbstractStructBase
{
    /**
     * The Operator
     * Meta informations extracted from the WSDL
     * - documentation: Company or organization operating the trip/tour/cruise
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $Operator;
    /**
     * Constructor method for Operators
     * @uses Operators::setOperator()
     * @param mixed[] $operator
     */
    public function __construct(array $operator = array())
    {
        $this
            ->setOperator($operator);
    }
    /**
     * Get Operator value
     * @return mixed[]|null
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @throws \InvalidArgumentException
     * @param mixed[] $operator
     * @return \StructType\Operators
     */
    public function setOperator(array $operator = array())
    {
        foreach ($operator as $operatorsOperatorItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The Operator property can only contain items of anyType, "%s" given', is_object($operatorsOperatorItem) ? get_class($operatorsOperatorItem) : gettype($operatorsOperatorItem)), __LINE__);
            }
        }
        $this->Operator = $operator;
        return $this;
    }
    /**
     * Add item to Operator value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Operators
     */
    public function addToOperator($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The Operator property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Operator[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Operators
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
