<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationTime StructType
 * Meta informations extracted from the WSDL
 * - documentation: Provides information on operational events for this flight leg e.g. off-ground. | Provides operating times of a facility.
 * @subpackage Structs
 */
class OperationTime extends AbstractStructBase
{
    /**
     * The Time
     * Meta informations extracted from the WSDL
     * - documentation: Time or date/time an operational event happened. | Allows for the specification of a date time or just time.
     * - use: required
     * - union: dateTime | time
     * @var string
     */
    public $Time;
    /**
     * The OperationType
     * Meta informations extracted from the WSDL
     * - documentation: Type of operational event (e.g., off-ground). References the OTA Code Table OTT. | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - use: required
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $OperationType;
    /**
     * The TimeType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TimeType;
    /**
     * The AdditionalOperationInfoCode
     * Meta informations extracted from the WSDL
     * - documentation: Used to provide additional information regarding operation times (e.g., after hours operations, restricted times). Refer to OTA Codelist Additional Operation Info (OPR).
     * - use: optional
     * @var string
     */
    public $AdditionalOperationInfoCode;
    /**
     * The ReasonCode
     * Meta informations extracted from the WSDL
     * - documentation: The reason attributed to a delay or cancellation. Refers to OTA Code Table FDC. | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - use: optional
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $ReasonCode;
    /**
     * Constructor method for OperationTime
     * @uses OperationTime::setTime()
     * @uses OperationTime::setOperationType()
     * @uses OperationTime::setTimeType()
     * @uses OperationTime::setAdditionalOperationInfoCode()
     * @uses OperationTime::setReasonCode()
     * @param string $time
     * @param string $operationType
     * @param string $timeType
     * @param string $additionalOperationInfoCode
     * @param string $reasonCode
     */
    public function __construct($time = null, $operationType = null, $timeType = null, $additionalOperationInfoCode = null, $reasonCode = null)
    {
        $this
            ->setTime($time)
            ->setOperationType($operationType)
            ->setTimeType($timeType)
            ->setAdditionalOperationInfoCode($additionalOperationInfoCode)
            ->setReasonCode($reasonCode);
    }
    /**
     * Get Time value
     * @return string
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \StructType\OperationTime
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get OperationType value
     * @return string
     */
    public function getOperationType()
    {
        return $this->OperationType;
    }
    /**
     * Set OperationType value
     * @param string $operationType
     * @return \StructType\OperationTime
     */
    public function setOperationType($operationType = null)
    {
        // validation for constraint: pattern
        if (is_scalar($operationType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $operationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}", "%s" given', var_export($operationType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operationType) && !is_string($operationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationType)), __LINE__);
        }
        $this->OperationType = $operationType;
        return $this;
    }
    /**
     * Get TimeType value
     * @return string
     */
    public function getTimeType()
    {
        return $this->TimeType;
    }
    /**
     * Set TimeType value
     * @param string $timeType
     * @return \StructType\OperationTime
     */
    public function setTimeType($timeType = null)
    {
        // validation for constraint: string
        if (!is_null($timeType) && !is_string($timeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeType)), __LINE__);
        }
        $this->TimeType = $timeType;
        return $this;
    }
    /**
     * Get AdditionalOperationInfoCode value
     * @return string|null
     */
    public function getAdditionalOperationInfoCode()
    {
        return $this->AdditionalOperationInfoCode;
    }
    /**
     * Set AdditionalOperationInfoCode value
     * @param string $additionalOperationInfoCode
     * @return \StructType\OperationTime
     */
    public function setAdditionalOperationInfoCode($additionalOperationInfoCode = null)
    {
        // validation for constraint: string
        if (!is_null($additionalOperationInfoCode) && !is_string($additionalOperationInfoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additionalOperationInfoCode)), __LINE__);
        }
        $this->AdditionalOperationInfoCode = $additionalOperationInfoCode;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \StructType\OperationTime
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($reasonCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}", "%s" given', var_export($reasonCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperationTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
