<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatingAirlineType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This is an extension of CompanyNameType to include a FlightNumber.
 * @subpackage Structs
 */
class OperatingAirlineType extends CompanyNameType
{
    /**
     * The FlightNumber
     * @var string
     */
    public $FlightNumber;
    /**
     * Constructor method for OperatingAirlineType
     * @uses OperatingAirlineType::setFlightNumber()
     * @param string $flightNumber
     */
    public function __construct($flightNumber = null)
    {
        $this
            ->setFlightNumber($flightNumber);
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\OperatingAirlineType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperatingAirlineType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
