<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnDBaggageDetailsResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: One BaggageDetailsResponse element is returned for combine flight segments requested in the input request.
 * @subpackage Structs
 */
class OnDBaggageDetailsResponse extends AbstractStructBase
{
    /**
     * The OnDFlightSegmentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\OnDFlightSegmentInfo[]
     */
    public $OnDFlightSegmentInfo;
    /**
     * The Baggage
     * Meta informations extracted from the WSDL
     * - documentation: This identifies the baggage details for the flight segment in the corresponding 'FlightSegmentInfo' element.
     * - maxOccurs: 99
     * @var \StructType\Baggage[]
     */
    public $Baggage;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: This is used for PNR record locator. If there are more than one PNR numbers because of muliple airlines in the itinerary then this element could be repeated.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $BookingReferenceID;
    /**
     * Constructor method for OnDBaggageDetailsResponse
     * @uses OnDBaggageDetailsResponse::setOnDFlightSegmentInfo()
     * @uses OnDBaggageDetailsResponse::setBaggage()
     * @uses OnDBaggageDetailsResponse::setBookingReferenceID()
     * @param \StructType\OnDFlightSegmentInfo[] $onDFlightSegmentInfo
     * @param \StructType\Baggage[] $baggage
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     */
    public function __construct(array $onDFlightSegmentInfo = array(), array $baggage = array(), array $bookingReferenceID = array())
    {
        $this
            ->setOnDFlightSegmentInfo($onDFlightSegmentInfo)
            ->setBaggage($baggage)
            ->setBookingReferenceID($bookingReferenceID);
    }
    /**
     * Get OnDFlightSegmentInfo value
     * @return \StructType\OnDFlightSegmentInfo[]|null
     */
    public function getOnDFlightSegmentInfo()
    {
        return $this->OnDFlightSegmentInfo;
    }
    /**
     * Set OnDFlightSegmentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OnDFlightSegmentInfo[] $onDFlightSegmentInfo
     * @return \StructType\OnDBaggageDetailsResponse
     */
    public function setOnDFlightSegmentInfo(array $onDFlightSegmentInfo = array())
    {
        foreach ($onDFlightSegmentInfo as $onDBaggageDetailsResponseOnDFlightSegmentInfoItem) {
            // validation for constraint: itemType
            if (!$onDBaggageDetailsResponseOnDFlightSegmentInfoItem instanceof \StructType\OnDFlightSegmentInfo) {
                throw new \InvalidArgumentException(sprintf('The OnDFlightSegmentInfo property can only contain items of \StructType\OnDFlightSegmentInfo, "%s" given', is_object($onDBaggageDetailsResponseOnDFlightSegmentInfoItem) ? get_class($onDBaggageDetailsResponseOnDFlightSegmentInfoItem) : gettype($onDBaggageDetailsResponseOnDFlightSegmentInfoItem)), __LINE__);
            }
        }
        $this->OnDFlightSegmentInfo = $onDFlightSegmentInfo;
        return $this;
    }
    /**
     * Add item to OnDFlightSegmentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OnDFlightSegmentInfo $item
     * @return \StructType\OnDBaggageDetailsResponse
     */
    public function addToOnDFlightSegmentInfo(\StructType\OnDFlightSegmentInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OnDFlightSegmentInfo) {
            throw new \InvalidArgumentException(sprintf('The OnDFlightSegmentInfo property can only contain items of \StructType\OnDFlightSegmentInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OnDFlightSegmentInfo[] = $item;
        return $this;
    }
    /**
     * Get Baggage value
     * @return \StructType\Baggage[]|null
     */
    public function getBaggage()
    {
        return $this->Baggage;
    }
    /**
     * Set Baggage value
     * @throws \InvalidArgumentException
     * @param \StructType\Baggage[] $baggage
     * @return \StructType\OnDBaggageDetailsResponse
     */
    public function setBaggage(array $baggage = array())
    {
        foreach ($baggage as $onDBaggageDetailsResponseBaggageItem) {
            // validation for constraint: itemType
            if (!$onDBaggageDetailsResponseBaggageItem instanceof \StructType\Baggage) {
                throw new \InvalidArgumentException(sprintf('The Baggage property can only contain items of \StructType\Baggage, "%s" given', is_object($onDBaggageDetailsResponseBaggageItem) ? get_class($onDBaggageDetailsResponseBaggageItem) : gettype($onDBaggageDetailsResponseBaggageItem)), __LINE__);
            }
        }
        $this->Baggage = $baggage;
        return $this;
    }
    /**
     * Add item to Baggage value
     * @throws \InvalidArgumentException
     * @param \StructType\Baggage $item
     * @return \StructType\OnDBaggageDetailsResponse
     */
    public function addToBaggage(\StructType\Baggage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Baggage) {
            throw new \InvalidArgumentException(sprintf('The Baggage property can only contain items of \StructType\Baggage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Baggage[] = $item;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     * @return \StructType\OnDBaggageDetailsResponse
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        foreach ($bookingReferenceID as $onDBaggageDetailsResponseBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$onDBaggageDetailsResponseBookingReferenceIDItem instanceof \StructType\UniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($onDBaggageDetailsResponseBookingReferenceIDItem) ? get_class($onDBaggageDetailsResponseBookingReferenceIDItem) : gettype($onDBaggageDetailsResponseBookingReferenceIDItem)), __LINE__);
            }
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\OnDBaggageDetailsResponse
     */
    public function addToBookingReferenceID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OnDBaggageDetailsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
