<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirPriceRQ StructType
 * Meta informations extracted from the WSDL
 * - documentation: The Availability Request message requests pricing information for specific flights on specific dates for a specific number and type of passengers. Optional information in the message allows fare restriction preferences and negotiated
 * fare contract codes to be included in the message.The pricing request contains the information necessary to perform an availability / sell from availability / price series of entries on an airline CRS or GDS.
 * @subpackage Structs
 */
class OTA_AirPriceRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - documentation: Point of sale object.
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The AirItinerary
     * Meta informations extracted from the WSDL
     * - documentation: The Air Itineraries to be priced
     * @var \StructType\AirItineraryType
     */
    public $AirItinerary;
    /**
     * The TravelerInfoSummary
     * Meta informations extracted from the WSDL
     * - documentation: Specify passenger numbers and types
     * @var \StructType\TravelerInfoSummaryType
     */
    public $TravelerInfoSummary;
    /**
     * The ModifiedSegmentInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ModifiedSegmentInfo
     */
    public $ModifiedSegmentInfo;
    /**
     * The FlexiFareSelectionOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FlexiFareSelectionOptions
     */
    public $FlexiFareSelectionOptions;
    /**
     * The BundledServiceSelectionOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BundledServiceSelectionOptions
     */
    public $BundledServiceSelectionOptions;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_AirPriceRQ
     * @uses OTA_AirPriceRQ::setPOS()
     * @uses OTA_AirPriceRQ::setAirItinerary()
     * @uses OTA_AirPriceRQ::setTravelerInfoSummary()
     * @uses OTA_AirPriceRQ::setModifiedSegmentInfo()
     * @uses OTA_AirPriceRQ::setFlexiFareSelectionOptions()
     * @uses OTA_AirPriceRQ::setBundledServiceSelectionOptions()
     * @uses OTA_AirPriceRQ::setEchoToken()
     * @uses OTA_AirPriceRQ::setTimeStamp()
     * @uses OTA_AirPriceRQ::setTarget()
     * @uses OTA_AirPriceRQ::setVersion()
     * @uses OTA_AirPriceRQ::setTransactionIdentifier()
     * @uses OTA_AirPriceRQ::setSequenceNmbr()
     * @uses OTA_AirPriceRQ::setTransactionStatusCode()
     * @uses OTA_AirPriceRQ::setRetransmissionIndicator()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\AirItineraryType $airItinerary
     * @param \StructType\TravelerInfoSummaryType $travelerInfoSummary
     * @param \StructType\ModifiedSegmentInfo $modifiedSegmentInfo
     * @param \StructType\FlexiFareSelectionOptions $flexiFareSelectionOptions
     * @param \StructType\BundledServiceSelectionOptions $bundledServiceSelectionOptions
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct(\StructType\POS_Type $pOS = null, \StructType\AirItineraryType $airItinerary = null, \StructType\TravelerInfoSummaryType $travelerInfoSummary = null, \StructType\ModifiedSegmentInfo $modifiedSegmentInfo = null, \StructType\FlexiFareSelectionOptions $flexiFareSelectionOptions = null, \StructType\BundledServiceSelectionOptions $bundledServiceSelectionOptions = null, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setPOS($pOS)
            ->setAirItinerary($airItinerary)
            ->setTravelerInfoSummary($travelerInfoSummary)
            ->setModifiedSegmentInfo($modifiedSegmentInfo)
            ->setFlexiFareSelectionOptions($flexiFareSelectionOptions)
            ->setBundledServiceSelectionOptions($bundledServiceSelectionOptions)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get AirItinerary value
     * @return \StructType\AirItineraryType|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param \StructType\AirItineraryType $airItinerary
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setAirItinerary(\StructType\AirItineraryType $airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get TravelerInfoSummary value
     * @return \StructType\TravelerInfoSummaryType|null
     */
    public function getTravelerInfoSummary()
    {
        return $this->TravelerInfoSummary;
    }
    /**
     * Set TravelerInfoSummary value
     * @param \StructType\TravelerInfoSummaryType $travelerInfoSummary
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setTravelerInfoSummary(\StructType\TravelerInfoSummaryType $travelerInfoSummary = null)
    {
        $this->TravelerInfoSummary = $travelerInfoSummary;
        return $this;
    }
    /**
     * Get ModifiedSegmentInfo value
     * @return \StructType\ModifiedSegmentInfo|null
     */
    public function getModifiedSegmentInfo()
    {
        return $this->ModifiedSegmentInfo;
    }
    /**
     * Set ModifiedSegmentInfo value
     * @param \StructType\ModifiedSegmentInfo $modifiedSegmentInfo
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setModifiedSegmentInfo(\StructType\ModifiedSegmentInfo $modifiedSegmentInfo = null)
    {
        $this->ModifiedSegmentInfo = $modifiedSegmentInfo;
        return $this;
    }
    /**
     * Get FlexiFareSelectionOptions value
     * @return \StructType\FlexiFareSelectionOptions|null
     */
    public function getFlexiFareSelectionOptions()
    {
        return $this->FlexiFareSelectionOptions;
    }
    /**
     * Set FlexiFareSelectionOptions value
     * @param \StructType\FlexiFareSelectionOptions $flexiFareSelectionOptions
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setFlexiFareSelectionOptions(\StructType\FlexiFareSelectionOptions $flexiFareSelectionOptions = null)
    {
        $this->FlexiFareSelectionOptions = $flexiFareSelectionOptions;
        return $this;
    }
    /**
     * Get BundledServiceSelectionOptions value
     * @return \StructType\BundledServiceSelectionOptions|null
     */
    public function getBundledServiceSelectionOptions()
    {
        return $this->BundledServiceSelectionOptions;
    }
    /**
     * Set BundledServiceSelectionOptions value
     * @param \StructType\BundledServiceSelectionOptions $bundledServiceSelectionOptions
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setBundledServiceSelectionOptions(\StructType\BundledServiceSelectionOptions $bundledServiceSelectionOptions = null)
    {
        $this->BundledServiceSelectionOptions = $bundledServiceSelectionOptions;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_AirPriceRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_AirPriceRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
