<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirFlifoRQ StructType
 * Meta informations extracted from the WSDL
 * - documentation: Retrieve real-time flight departure, arrival and gate information for a particular flight, including actual as well as scheduled departure and arrival times.
 * @subpackage Structs
 */
class OTA_AirFlifoRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - documentation: Point of sale object.
     * - minOccurs: 0
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - documentation: Specify airline to request FLIFO details.
     * @var \StructType\CompanyNameType
     */
    public $Airline;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - documentation: Specific flight number to request details for. Requires that Airline is also supplied.
     * @var string
     */
    public $FlightNumber;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: Date of departure for flight information.
     * @var string
     */
    public $DepartureDate;
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the departure location.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the arrival location.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $ArrivalAirport;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_AirFlifoRQ
     * @uses OTA_AirFlifoRQ::setPOS()
     * @uses OTA_AirFlifoRQ::setAirline()
     * @uses OTA_AirFlifoRQ::setFlightNumber()
     * @uses OTA_AirFlifoRQ::setDepartureDate()
     * @uses OTA_AirFlifoRQ::setDepartureAirport()
     * @uses OTA_AirFlifoRQ::setArrivalAirport()
     * @uses OTA_AirFlifoRQ::setEchoToken()
     * @uses OTA_AirFlifoRQ::setTimeStamp()
     * @uses OTA_AirFlifoRQ::setTarget()
     * @uses OTA_AirFlifoRQ::setVersion()
     * @uses OTA_AirFlifoRQ::setTransactionIdentifier()
     * @uses OTA_AirFlifoRQ::setSequenceNmbr()
     * @uses OTA_AirFlifoRQ::setTransactionStatusCode()
     * @uses OTA_AirFlifoRQ::setRetransmissionIndicator()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\CompanyNameType $airline
     * @param string $flightNumber
     * @param string $departureDate
     * @param \StructType\LocationType $departureAirport
     * @param \StructType\LocationType $arrivalAirport
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct(\StructType\POS_Type $pOS = null, \StructType\CompanyNameType $airline = null, $flightNumber = null, $departureDate = null, \StructType\LocationType $departureAirport = null, \StructType\LocationType $arrivalAirport = null, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setPOS($pOS)
            ->setAirline($airline)
            ->setFlightNumber($flightNumber)
            ->setDepartureDate($departureDate)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Airline value
     * @return \StructType\CompanyNameType|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \StructType\CompanyNameType $airline
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setAirline(\StructType\CompanyNameType $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @uses \EnumType\FlightNumberType::valueIsValid()
     * @uses \EnumType\FlightNumberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flightNumber
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FlightNumberType::valueIsValid($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $flightNumber, implode(', ', \EnumType\FlightNumberType::getValidValues())), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \StructType\LocationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \StructType\LocationType $departureAirport
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setDepartureAirport(\StructType\LocationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \StructType\LocationType|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \StructType\LocationType $arrivalAirport
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setArrivalAirport(\StructType\LocationType $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_AirFlifoRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_AirFlifoRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
