<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirBookRS StructType
 * Meta informations extracted from the WSDL
 * - documentation: The Book Response message contains the itinerary, passenger and pricing information sent in the request, along with a Booking reference number (PNR Locator) and ticketing information if the booking was successful.This message
 * contains similar information to a standard airline CRS or GDS Display PNR message. | The OTA_PayloadStdAttributes defines the standard attributes that appear on the root element for all OTA payloads.
 * @subpackage Structs
 */
class OTA_AirBookRS extends AbstractStructBase
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - documentation: Standard way to indicate successful processing of an OTA message. Returning an empty element of this type indicates success.
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - documentation: Standard way to indicate successful processing of an OTA message, but one in which warnings are generated.
     * - minOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * The AirReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\AirReservation[]
     */
    public $AirReservation;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - documentation: A collection of errors that occurred during the processing of a message.
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The Cancel
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: AWG to revisit.
     * @var bool
     */
    public $Cancel;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_AirBookRS
     * @uses OTA_AirBookRS::setSuccess()
     * @uses OTA_AirBookRS::setWarnings()
     * @uses OTA_AirBookRS::setAirReservation()
     * @uses OTA_AirBookRS::setErrors()
     * @uses OTA_AirBookRS::setCancel()
     * @uses OTA_AirBookRS::setEchoToken()
     * @uses OTA_AirBookRS::setTimeStamp()
     * @uses OTA_AirBookRS::setTarget()
     * @uses OTA_AirBookRS::setVersion()
     * @uses OTA_AirBookRS::setTransactionIdentifier()
     * @uses OTA_AirBookRS::setSequenceNmbr()
     * @uses OTA_AirBookRS::setTransactionStatusCode()
     * @uses OTA_AirBookRS::setRetransmissionIndicator()
     * @param \StructType\SuccessType $success
     * @param \StructType\WarningsType $warnings
     * @param \StructType\AirReservation[] $airReservation
     * @param \StructType\ErrorsType $errors
     * @param bool $cancel
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct(\StructType\SuccessType $success = null, \StructType\WarningsType $warnings = null, array $airReservation = array(), \StructType\ErrorsType $errors = null, $cancel = false, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setAirReservation($airReservation)
            ->setErrors($errors)
            ->setCancel($cancel)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \StructType\SuccessType $success
     * @return \StructType\OTA_AirBookRS
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\WarningsType $warnings
     * @return \StructType\OTA_AirBookRS
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get AirReservation value
     * @return \StructType\AirReservation[]|null
     */
    public function getAirReservation()
    {
        return $this->AirReservation;
    }
    /**
     * Set AirReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\AirReservation[] $airReservation
     * @return \StructType\OTA_AirBookRS
     */
    public function setAirReservation(array $airReservation = array())
    {
        foreach ($airReservation as $oTA_AirBookRSAirReservationItem) {
            // validation for constraint: itemType
            if (!$oTA_AirBookRSAirReservationItem instanceof \StructType\AirReservation) {
                throw new \InvalidArgumentException(sprintf('The AirReservation property can only contain items of \StructType\AirReservation, "%s" given', is_object($oTA_AirBookRSAirReservationItem) ? get_class($oTA_AirBookRSAirReservationItem) : gettype($oTA_AirBookRSAirReservationItem)), __LINE__);
            }
        }
        $this->AirReservation = $airReservation;
        return $this;
    }
    /**
     * Add item to AirReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\AirReservation $item
     * @return \StructType\OTA_AirBookRS
     */
    public function addToAirReservation(\StructType\AirReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirReservation) {
            throw new \InvalidArgumentException(sprintf('The AirReservation property can only contain items of \StructType\AirReservation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirReservation[] = $item;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\ErrorsType $errors
     * @return \StructType\OTA_AirBookRS
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Cancel value
     * @return bool|null
     */
    public function getCancel()
    {
        return $this->Cancel;
    }
    /**
     * Set Cancel value
     * @param bool $cancel
     * @return \StructType\OTA_AirBookRS
     */
    public function setCancel($cancel = false)
    {
        // validation for constraint: boolean
        if (!is_null($cancel) && !is_bool($cancel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cancel)), __LINE__);
        }
        $this->Cancel = $cancel;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_AirBookRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_AirBookRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_AirBookRS
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_AirBookRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_AirBookRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_AirBookRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_AirBookRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_AirBookRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_AirBookRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
