<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirAvailRQ StructType
 * Meta informations extracted from the WSDL
 * - documentation: The Availability Request message requests Flight Availability for a city pair on a specific date for a specific number and type of passengers. Optional request information can include:- Time / Time Window- Connecting cities.- Client
 * Preferences (airlines, cabin, flight types etc.)The request can be narrowed to request availability for a specific airline, specific flight, or specific booking class on a specific flight.The availability request message contains similar information
 * to a standard Airline CRS or GDS availability request message. | Maximum number of responses desired in the response message.
 * @subpackage Structs
 */
class OTA_AirAvailRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - documentation: Point of sale object.
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The ProcessingInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProcessingInfo
     */
    public $ProcessingInfo;
    /**
     * The OriginDestinationInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * @var \StructType\OriginDestinationInformation[]
     */
    public $OriginDestinationInformation;
    /**
     * The SpecificFlightInfo
     * Meta informations extracted from the WSDL
     * - documentation: Information used to specify a flight for which availablity is to be checked.
     * - minOccurs: 0
     * @var \StructType\SpecificFlightInfoType
     */
    public $SpecificFlightInfo;
    /**
     * The TravelPreferences
     * Meta informations extracted from the WSDL
     * - documentation: Air Availability Request preference information.
     * - minOccurs: 0
     * @var \StructType\AirSearchPrefsType
     */
    public $TravelPreferences;
    /**
     * The TravelerInfoSummary
     * Meta informations extracted from the WSDL
     * - documentation: Used to specify passenger and fare information for which availablity is to be checked.
     * - minOccurs: 0
     * @var \StructType\TravelerInfoSummaryType
     */
    public $TravelerInfoSummary;
    /**
     * The ModifiedSegmentInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ModifiedSegmentInfo
     */
    public $ModifiedSegmentInfo;
    /**
     * The FlexiQuote
     * Meta informations extracted from the WSDL
     * - documentation: A boolean flag to indicate whether to quote the flexi-charges with the availability search.
     * - minOccurs: 0
     * @var bool
     */
    public $FlexiQuote;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The MaxResponses
     * @var int
     */
    public $MaxResponses;
    /**
     * The DirectFlightsOnly
     * @var bool
     */
    public $DirectFlightsOnly;
    /**
     * The NumberStops
     * @var string
     */
    public $NumberStops;
    /**
     * Constructor method for OTA_AirAvailRQ
     * @uses OTA_AirAvailRQ::setPOS()
     * @uses OTA_AirAvailRQ::setProcessingInfo()
     * @uses OTA_AirAvailRQ::setOriginDestinationInformation()
     * @uses OTA_AirAvailRQ::setSpecificFlightInfo()
     * @uses OTA_AirAvailRQ::setTravelPreferences()
     * @uses OTA_AirAvailRQ::setTravelerInfoSummary()
     * @uses OTA_AirAvailRQ::setModifiedSegmentInfo()
     * @uses OTA_AirAvailRQ::setFlexiQuote()
     * @uses OTA_AirAvailRQ::setEchoToken()
     * @uses OTA_AirAvailRQ::setTimeStamp()
     * @uses OTA_AirAvailRQ::setTarget()
     * @uses OTA_AirAvailRQ::setVersion()
     * @uses OTA_AirAvailRQ::setTransactionIdentifier()
     * @uses OTA_AirAvailRQ::setSequenceNmbr()
     * @uses OTA_AirAvailRQ::setTransactionStatusCode()
     * @uses OTA_AirAvailRQ::setRetransmissionIndicator()
     * @uses OTA_AirAvailRQ::setMaxResponses()
     * @uses OTA_AirAvailRQ::setDirectFlightsOnly()
     * @uses OTA_AirAvailRQ::setNumberStops()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\ProcessingInfo $processingInfo
     * @param \StructType\OriginDestinationInformation[] $originDestinationInformation
     * @param \StructType\SpecificFlightInfoType $specificFlightInfo
     * @param \StructType\AirSearchPrefsType $travelPreferences
     * @param \StructType\TravelerInfoSummaryType $travelerInfoSummary
     * @param \StructType\ModifiedSegmentInfo $modifiedSegmentInfo
     * @param bool $flexiQuote
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param int $maxResponses
     * @param bool $directFlightsOnly
     * @param string $numberStops
     */
    public function __construct(\StructType\POS_Type $pOS = null, \StructType\ProcessingInfo $processingInfo = null, array $originDestinationInformation = array(), \StructType\SpecificFlightInfoType $specificFlightInfo = null, \StructType\AirSearchPrefsType $travelPreferences = null, \StructType\TravelerInfoSummaryType $travelerInfoSummary = null, \StructType\ModifiedSegmentInfo $modifiedSegmentInfo = null, $flexiQuote = null, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $maxResponses = null, $directFlightsOnly = null, $numberStops = null)
    {
        $this
            ->setPOS($pOS)
            ->setProcessingInfo($processingInfo)
            ->setOriginDestinationInformation($originDestinationInformation)
            ->setSpecificFlightInfo($specificFlightInfo)
            ->setTravelPreferences($travelPreferences)
            ->setTravelerInfoSummary($travelerInfoSummary)
            ->setModifiedSegmentInfo($modifiedSegmentInfo)
            ->setFlexiQuote($flexiQuote)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setMaxResponses($maxResponses)
            ->setDirectFlightsOnly($directFlightsOnly)
            ->setNumberStops($numberStops);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get ProcessingInfo value
     * @return \StructType\ProcessingInfo|null
     */
    public function getProcessingInfo()
    {
        return $this->ProcessingInfo;
    }
    /**
     * Set ProcessingInfo value
     * @param \StructType\ProcessingInfo $processingInfo
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setProcessingInfo(\StructType\ProcessingInfo $processingInfo = null)
    {
        $this->ProcessingInfo = $processingInfo;
        return $this;
    }
    /**
     * Get OriginDestinationInformation value
     * @return \StructType\OriginDestinationInformation[]|null
     */
    public function getOriginDestinationInformation()
    {
        return $this->OriginDestinationInformation;
    }
    /**
     * Set OriginDestinationInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginDestinationInformation[] $originDestinationInformation
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setOriginDestinationInformation(array $originDestinationInformation = array())
    {
        foreach ($originDestinationInformation as $oTA_AirAvailRQOriginDestinationInformationItem) {
            // validation for constraint: itemType
            if (!$oTA_AirAvailRQOriginDestinationInformationItem instanceof \StructType\OriginDestinationInformation) {
                throw new \InvalidArgumentException(sprintf('The OriginDestinationInformation property can only contain items of \StructType\OriginDestinationInformation, "%s" given', is_object($oTA_AirAvailRQOriginDestinationInformationItem) ? get_class($oTA_AirAvailRQOriginDestinationInformationItem) : gettype($oTA_AirAvailRQOriginDestinationInformationItem)), __LINE__);
            }
        }
        $this->OriginDestinationInformation = $originDestinationInformation;
        return $this;
    }
    /**
     * Add item to OriginDestinationInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginDestinationInformation $item
     * @return \StructType\OTA_AirAvailRQ
     */
    public function addToOriginDestinationInformation(\StructType\OriginDestinationInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OriginDestinationInformation) {
            throw new \InvalidArgumentException(sprintf('The OriginDestinationInformation property can only contain items of \StructType\OriginDestinationInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OriginDestinationInformation[] = $item;
        return $this;
    }
    /**
     * Get SpecificFlightInfo value
     * @return \StructType\SpecificFlightInfoType|null
     */
    public function getSpecificFlightInfo()
    {
        return $this->SpecificFlightInfo;
    }
    /**
     * Set SpecificFlightInfo value
     * @param \StructType\SpecificFlightInfoType $specificFlightInfo
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setSpecificFlightInfo(\StructType\SpecificFlightInfoType $specificFlightInfo = null)
    {
        $this->SpecificFlightInfo = $specificFlightInfo;
        return $this;
    }
    /**
     * Get TravelPreferences value
     * @return \StructType\AirSearchPrefsType|null
     */
    public function getTravelPreferences()
    {
        return $this->TravelPreferences;
    }
    /**
     * Set TravelPreferences value
     * @param \StructType\AirSearchPrefsType $travelPreferences
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setTravelPreferences(\StructType\AirSearchPrefsType $travelPreferences = null)
    {
        $this->TravelPreferences = $travelPreferences;
        return $this;
    }
    /**
     * Get TravelerInfoSummary value
     * @return \StructType\TravelerInfoSummaryType|null
     */
    public function getTravelerInfoSummary()
    {
        return $this->TravelerInfoSummary;
    }
    /**
     * Set TravelerInfoSummary value
     * @param \StructType\TravelerInfoSummaryType $travelerInfoSummary
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setTravelerInfoSummary(\StructType\TravelerInfoSummaryType $travelerInfoSummary = null)
    {
        $this->TravelerInfoSummary = $travelerInfoSummary;
        return $this;
    }
    /**
     * Get ModifiedSegmentInfo value
     * @return \StructType\ModifiedSegmentInfo|null
     */
    public function getModifiedSegmentInfo()
    {
        return $this->ModifiedSegmentInfo;
    }
    /**
     * Set ModifiedSegmentInfo value
     * @param \StructType\ModifiedSegmentInfo $modifiedSegmentInfo
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setModifiedSegmentInfo(\StructType\ModifiedSegmentInfo $modifiedSegmentInfo = null)
    {
        $this->ModifiedSegmentInfo = $modifiedSegmentInfo;
        return $this;
    }
    /**
     * Get FlexiQuote value
     * @return bool|null
     */
    public function getFlexiQuote()
    {
        return $this->FlexiQuote;
    }
    /**
     * Set FlexiQuote value
     * @param bool $flexiQuote
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setFlexiQuote($flexiQuote = null)
    {
        // validation for constraint: boolean
        if (!is_null($flexiQuote) && !is_bool($flexiQuote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($flexiQuote)), __LINE__);
        }
        $this->FlexiQuote = $flexiQuote;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get MaxResponses value
     * @return int|null
     */
    public function getMaxResponses()
    {
        return $this->MaxResponses;
    }
    /**
     * Set MaxResponses value
     * @param int $maxResponses
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setMaxResponses($maxResponses = null)
    {
        // validation for constraint: int
        if (!is_null($maxResponses) && !is_numeric($maxResponses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxResponses)), __LINE__);
        }
        $this->MaxResponses = $maxResponses;
        return $this;
    }
    /**
     * Get DirectFlightsOnly value
     * @return bool|null
     */
    public function getDirectFlightsOnly()
    {
        return $this->DirectFlightsOnly;
    }
    /**
     * Set DirectFlightsOnly value
     * @param bool $directFlightsOnly
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setDirectFlightsOnly($directFlightsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($directFlightsOnly) && !is_bool($directFlightsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($directFlightsOnly)), __LINE__);
        }
        $this->DirectFlightsOnly = $directFlightsOnly;
        return $this;
    }
    /**
     * Get NumberStops value
     * @return string|null
     */
    public function getNumberStops()
    {
        return $this->NumberStops;
    }
    /**
     * Set NumberStops value
     * @param string $numberStops
     * @return \StructType\OTA_AirAvailRQ
     */
    public function setNumberStops($numberStops = null)
    {
        // validation for constraint: string
        if (!is_null($numberStops) && !is_string($numberStops)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberStops)), __LINE__);
        }
        $this->NumberStops = $numberStops;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_AirAvailRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
