<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealDetails StructType
 * Meta informations extracted from the WSDL
 * - documentation: Object to hold the meal details that is to be requested.
 * @subpackage Structs
 */
class MealDetails extends AbstractStructBase
{
    /**
     * The CabinClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\CabinClass[]
     */
    public $CabinClass;
    /**
     * The ResBookDesignations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResBookDesignations
     */
    public $ResBookDesignations;
    /**
     * Constructor method for MealDetails
     * @uses MealDetails::setCabinClass()
     * @uses MealDetails::setResBookDesignations()
     * @param \StructType\CabinClass[] $cabinClass
     * @param \StructType\ResBookDesignations $resBookDesignations
     */
    public function __construct(array $cabinClass = array(), \StructType\ResBookDesignations $resBookDesignations = null)
    {
        $this
            ->setCabinClass($cabinClass)
            ->setResBookDesignations($resBookDesignations);
    }
    /**
     * Get CabinClass value
     * @return \StructType\CabinClass[]|null
     */
    public function getCabinClass()
    {
        return $this->CabinClass;
    }
    /**
     * Set CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass[] $cabinClass
     * @return \StructType\MealDetails
     */
    public function setCabinClass(array $cabinClass = array())
    {
        foreach ($cabinClass as $mealDetailsCabinClassItem) {
            // validation for constraint: itemType
            if (!$mealDetailsCabinClassItem instanceof \StructType\CabinClass) {
                throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of \StructType\CabinClass, "%s" given', is_object($mealDetailsCabinClassItem) ? get_class($mealDetailsCabinClassItem) : gettype($mealDetailsCabinClassItem)), __LINE__);
            }
        }
        $this->CabinClass = $cabinClass;
        return $this;
    }
    /**
     * Add item to CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass $item
     * @return \StructType\MealDetails
     */
    public function addToCabinClass(\StructType\CabinClass $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinClass) {
            throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of \StructType\CabinClass, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CabinClass[] = $item;
        return $this;
    }
    /**
     * Get ResBookDesignations value
     * @return \StructType\ResBookDesignations|null
     */
    public function getResBookDesignations()
    {
        return $this->ResBookDesignations;
    }
    /**
     * Set ResBookDesignations value
     * @param \StructType\ResBookDesignations $resBookDesignations
     * @return \StructType\MealDetails
     */
    public function setResBookDesignations(\StructType\ResBookDesignations $resBookDesignations = null)
    {
        $this->ResBookDesignations = $resBookDesignations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MealDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
