<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsCoverageDetailType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Provides vendor with information about the traveler(s)' requirements for insurance coverage.
 * @subpackage Structs
 */
class InsCoverageDetailType extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The CoverageRequirements
     * Meta informations extracted from the WSDL
     * - documentation: Container for any insurance coverage requirements shared by all travelers
     * - minOccurs: 0
     * @var mixed
     */
    public $CoverageRequirements;
    /**
     * The TotalTripQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalTripQuantity
     */
    public $TotalTripQuantity;
    /**
     * The MaximumTripLength
     * Meta informations extracted from the WSDL
     * - documentation: The maximum trip length the traveler(s) plan on taking during the period of coverage (Multi-Trip plans only).
     * - minOccurs: 0
     * @var mixed
     */
    public $MaximumTripLength;
    /**
     * The TotalTripCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalTripCost
     */
    public $TotalTripCost;
    /**
     * The CoveredTrips
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CoveredTrips
     */
    public $CoveredTrips;
    /**
     * The DeliveryPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $DeliveryPref;
    /**
     * The AutoRenew
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $AutoRenew;
    /**
     * Constructor method for InsCoverageDetailType
     * @uses InsCoverageDetailType::setType()
     * @uses InsCoverageDetailType::setCoverageRequirements()
     * @uses InsCoverageDetailType::setTotalTripQuantity()
     * @uses InsCoverageDetailType::setMaximumTripLength()
     * @uses InsCoverageDetailType::setTotalTripCost()
     * @uses InsCoverageDetailType::setCoveredTrips()
     * @uses InsCoverageDetailType::setDeliveryPref()
     * @uses InsCoverageDetailType::setAutoRenew()
     * @param string $type
     * @param mixed $coverageRequirements
     * @param \StructType\TotalTripQuantity $totalTripQuantity
     * @param mixed $maximumTripLength
     * @param \StructType\TotalTripCost $totalTripCost
     * @param \StructType\CoveredTrips $coveredTrips
     * @param mixed[] $deliveryPref
     * @param bool $autoRenew
     */
    public function __construct($type = null, $coverageRequirements = null, \StructType\TotalTripQuantity $totalTripQuantity = null, $maximumTripLength = null, \StructType\TotalTripCost $totalTripCost = null, \StructType\CoveredTrips $coveredTrips = null, array $deliveryPref = array(), $autoRenew = null)
    {
        $this
            ->setType($type)
            ->setCoverageRequirements($coverageRequirements)
            ->setTotalTripQuantity($totalTripQuantity)
            ->setMaximumTripLength($maximumTripLength)
            ->setTotalTripCost($totalTripCost)
            ->setCoveredTrips($coveredTrips)
            ->setDeliveryPref($deliveryPref)
            ->setAutoRenew($autoRenew);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\InsCoverageDetailType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CoverageRequirements value
     * @return mixed|null
     */
    public function getCoverageRequirements()
    {
        return $this->CoverageRequirements;
    }
    /**
     * Set CoverageRequirements value
     * @param mixed $coverageRequirements
     * @return \StructType\InsCoverageDetailType
     */
    public function setCoverageRequirements($coverageRequirements = null)
    {
        $this->CoverageRequirements = $coverageRequirements;
        return $this;
    }
    /**
     * Get TotalTripQuantity value
     * @return \StructType\TotalTripQuantity|null
     */
    public function getTotalTripQuantity()
    {
        return $this->TotalTripQuantity;
    }
    /**
     * Set TotalTripQuantity value
     * @param \StructType\TotalTripQuantity $totalTripQuantity
     * @return \StructType\InsCoverageDetailType
     */
    public function setTotalTripQuantity(\StructType\TotalTripQuantity $totalTripQuantity = null)
    {
        $this->TotalTripQuantity = $totalTripQuantity;
        return $this;
    }
    /**
     * Get MaximumTripLength value
     * @return mixed|null
     */
    public function getMaximumTripLength()
    {
        return $this->MaximumTripLength;
    }
    /**
     * Set MaximumTripLength value
     * @param mixed $maximumTripLength
     * @return \StructType\InsCoverageDetailType
     */
    public function setMaximumTripLength($maximumTripLength = null)
    {
        $this->MaximumTripLength = $maximumTripLength;
        return $this;
    }
    /**
     * Get TotalTripCost value
     * @return \StructType\TotalTripCost|null
     */
    public function getTotalTripCost()
    {
        return $this->TotalTripCost;
    }
    /**
     * Set TotalTripCost value
     * @param \StructType\TotalTripCost $totalTripCost
     * @return \StructType\InsCoverageDetailType
     */
    public function setTotalTripCost(\StructType\TotalTripCost $totalTripCost = null)
    {
        $this->TotalTripCost = $totalTripCost;
        return $this;
    }
    /**
     * Get CoveredTrips value
     * @return \StructType\CoveredTrips|null
     */
    public function getCoveredTrips()
    {
        return $this->CoveredTrips;
    }
    /**
     * Set CoveredTrips value
     * @param \StructType\CoveredTrips $coveredTrips
     * @return \StructType\InsCoverageDetailType
     */
    public function setCoveredTrips(\StructType\CoveredTrips $coveredTrips = null)
    {
        $this->CoveredTrips = $coveredTrips;
        return $this;
    }
    /**
     * Get DeliveryPref value
     * @return mixed[]|null
     */
    public function getDeliveryPref()
    {
        return $this->DeliveryPref;
    }
    /**
     * Set DeliveryPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $deliveryPref
     * @return \StructType\InsCoverageDetailType
     */
    public function setDeliveryPref(array $deliveryPref = array())
    {
        foreach ($deliveryPref as $insCoverageDetailTypeDeliveryPrefItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The DeliveryPref property can only contain items of anyType, "%s" given', is_object($insCoverageDetailTypeDeliveryPrefItem) ? get_class($insCoverageDetailTypeDeliveryPrefItem) : gettype($insCoverageDetailTypeDeliveryPrefItem)), __LINE__);
            }
        }
        $this->DeliveryPref = $deliveryPref;
        return $this;
    }
    /**
     * Add item to DeliveryPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\InsCoverageDetailType
     */
    public function addToDeliveryPref($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The DeliveryPref property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeliveryPref[] = $item;
        return $this;
    }
    /**
     * Get AutoRenew value
     * @return bool|null
     */
    public function getAutoRenew()
    {
        return $this->AutoRenew;
    }
    /**
     * Set AutoRenew value
     * @param bool $autoRenew
     * @return \StructType\InsCoverageDetailType
     */
    public function setAutoRenew($autoRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoRenew) && !is_bool($autoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($autoRenew)), __LINE__);
        }
        $this->AutoRenew = $autoRenew;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsCoverageDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
