<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InflightService StructType
 * @subpackage Structs
 */
class InflightService extends AbstractStructBase
{
    /**
     * The ssrCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $ssrCode;
    /**
     * The ssrName
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $ssrName;
    /**
     * The ssrDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $ssrDescription;
    /**
     * The serviceAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $serviceAmount;
    /**
     * The availableQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $availableQty;
    /**
     * Constructor method for InflightService
     * @uses InflightService::setSsrCode()
     * @uses InflightService::setSsrName()
     * @uses InflightService::setSsrDescription()
     * @uses InflightService::setServiceAmount()
     * @uses InflightService::setAvailableQty()
     * @param string $ssrCode
     * @param string $ssrName
     * @param string $ssrDescription
     * @param float $serviceAmount
     * @param int $availableQty
     */
    public function __construct($ssrCode = null, $ssrName = null, $ssrDescription = null, $serviceAmount = null, $availableQty = null)
    {
        $this
            ->setSsrCode($ssrCode)
            ->setSsrName($ssrName)
            ->setSsrDescription($ssrDescription)
            ->setServiceAmount($serviceAmount)
            ->setAvailableQty($availableQty);
    }
    /**
     * Get ssrCode value
     * @return string
     */
    public function getSsrCode()
    {
        return $this->ssrCode;
    }
    /**
     * Set ssrCode value
     * @param string $ssrCode
     * @return \StructType\InflightService
     */
    public function setSsrCode($ssrCode = null)
    {
        // validation for constraint: string
        if (!is_null($ssrCode) && !is_string($ssrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssrCode)), __LINE__);
        }
        $this->ssrCode = $ssrCode;
        return $this;
    }
    /**
     * Get ssrName value
     * @return string
     */
    public function getSsrName()
    {
        return $this->ssrName;
    }
    /**
     * Set ssrName value
     * @param string $ssrName
     * @return \StructType\InflightService
     */
    public function setSsrName($ssrName = null)
    {
        // validation for constraint: string
        if (!is_null($ssrName) && !is_string($ssrName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssrName)), __LINE__);
        }
        $this->ssrName = $ssrName;
        return $this;
    }
    /**
     * Get ssrDescription value
     * @return string
     */
    public function getSsrDescription()
    {
        return $this->ssrDescription;
    }
    /**
     * Set ssrDescription value
     * @param string $ssrDescription
     * @return \StructType\InflightService
     */
    public function setSsrDescription($ssrDescription = null)
    {
        // validation for constraint: string
        if (!is_null($ssrDescription) && !is_string($ssrDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssrDescription)), __LINE__);
        }
        $this->ssrDescription = $ssrDescription;
        return $this;
    }
    /**
     * Get serviceAmount value
     * @return float
     */
    public function getServiceAmount()
    {
        return $this->serviceAmount;
    }
    /**
     * Set serviceAmount value
     * @param float $serviceAmount
     * @return \StructType\InflightService
     */
    public function setServiceAmount($serviceAmount = null)
    {
        $this->serviceAmount = $serviceAmount;
        return $this;
    }
    /**
     * Get availableQty value
     * @return int|null
     */
    public function getAvailableQty()
    {
        return $this->availableQty;
    }
    /**
     * Set availableQty value
     * @param int $availableQty
     * @return \StructType\InflightService
     */
    public function setAvailableQty($availableQty = null)
    {
        // validation for constraint: int
        if (!is_null($availableQty) && !is_numeric($availableQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($availableQty)), __LINE__);
        }
        $this->availableQty = $availableQty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InflightService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
