<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRef StructType
 * Meta informations extracted from the WSDL
 * - documentation: Indicates the detail of hotel reference information.
 * @subpackage Structs
 */
class HotelRef extends AbstractStructBase
{
    /**
     * The SegmentCategoryCode
     * Meta informations extracted from the WSDL
     * - documentation: Used to search for hotels within a particular market segment. Refer to OTA Code Segment Category Code Type (SEG).
     * - use: optional
     * @var string
     */
    public $SegmentCategoryCode;
    /**
     * The PropertyClassCode
     * Meta informations extracted from the WSDL
     * - documentation: Refer to OTA Code list OTA Code List Property Class Type (PCT).
     * - use: optional
     * @var string
     */
    public $PropertyClassCode;
    /**
     * The ArchitecturalStyleCode
     * Meta informations extracted from the WSDL
     * - documentation: Refer to OTA Code List Architectural Style Code (ARC).
     * - use: optional
     * @var string
     */
    public $ArchitecturalStyleCode;
    /**
     * Constructor method for HotelRef
     * @uses HotelRef::setSegmentCategoryCode()
     * @uses HotelRef::setPropertyClassCode()
     * @uses HotelRef::setArchitecturalStyleCode()
     * @param string $segmentCategoryCode
     * @param string $propertyClassCode
     * @param string $architecturalStyleCode
     */
    public function __construct($segmentCategoryCode = null, $propertyClassCode = null, $architecturalStyleCode = null)
    {
        $this
            ->setSegmentCategoryCode($segmentCategoryCode)
            ->setPropertyClassCode($propertyClassCode)
            ->setArchitecturalStyleCode($architecturalStyleCode);
    }
    /**
     * Get SegmentCategoryCode value
     * @return string|null
     */
    public function getSegmentCategoryCode()
    {
        return $this->SegmentCategoryCode;
    }
    /**
     * Set SegmentCategoryCode value
     * @param string $segmentCategoryCode
     * @return \StructType\HotelRef
     */
    public function setSegmentCategoryCode($segmentCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentCategoryCode) && !is_string($segmentCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentCategoryCode)), __LINE__);
        }
        $this->SegmentCategoryCode = $segmentCategoryCode;
        return $this;
    }
    /**
     * Get PropertyClassCode value
     * @return string|null
     */
    public function getPropertyClassCode()
    {
        return $this->PropertyClassCode;
    }
    /**
     * Set PropertyClassCode value
     * @param string $propertyClassCode
     * @return \StructType\HotelRef
     */
    public function setPropertyClassCode($propertyClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyClassCode) && !is_string($propertyClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyClassCode)), __LINE__);
        }
        $this->PropertyClassCode = $propertyClassCode;
        return $this;
    }
    /**
     * Get ArchitecturalStyleCode value
     * @return string|null
     */
    public function getArchitecturalStyleCode()
    {
        return $this->ArchitecturalStyleCode;
    }
    /**
     * Set ArchitecturalStyleCode value
     * @param string $architecturalStyleCode
     * @return \StructType\HotelRef
     */
    public function setArchitecturalStyleCode($architecturalStyleCode = null)
    {
        // validation for constraint: string
        if (!is_null($architecturalStyleCode) && !is_string($architecturalStyleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($architecturalStyleCode)), __LINE__);
        }
        $this->ArchitecturalStyleCode = $architecturalStyleCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
