<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GlobalReservation StructType
 * Meta informations extracted from the WSDL
 * - documentation: One line in a list of reservations from a global distribution system. It may contain the booking reference, the person name, start date, and an itinerary name.
 * @subpackage Structs
 */
class GlobalReservation extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - documentation: The booking reference ID.
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The TravelerName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the first traveler in the reservation.
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $TravelerName;
    /**
     * The ItineraryName
     * Meta informations extracted from the WSDL
     * - documentation: A name given to this itinerary. | Used for Character Strings, length 0 to 64
     * - use: optional
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $ItineraryName;
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - documentation: The first date of the reservation, i.e., check-in date, departure date, pickup date, etc. | A construct to validate either a date or a dateTime value.
     * - use: optional
     * - union: date | dateTime
     * @var string
     */
    public $Start;
    /**
     * Constructor method for GlobalReservation
     * @uses GlobalReservation::setUniqueID()
     * @uses GlobalReservation::setTravelerName()
     * @uses GlobalReservation::setItineraryName()
     * @uses GlobalReservation::setStart()
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\PersonNameType $travelerName
     * @param string $itineraryName
     * @param string $start
     */
    public function __construct(\StructType\UniqueID_Type $uniqueID = null, \StructType\PersonNameType $travelerName = null, $itineraryName = null, $start = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setTravelerName($travelerName)
            ->setItineraryName($itineraryName)
            ->setStart($start);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\GlobalReservation
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get TravelerName value
     * @return \StructType\PersonNameType|null
     */
    public function getTravelerName()
    {
        return $this->TravelerName;
    }
    /**
     * Set TravelerName value
     * @param \StructType\PersonNameType $travelerName
     * @return \StructType\GlobalReservation
     */
    public function setTravelerName(\StructType\PersonNameType $travelerName = null)
    {
        $this->TravelerName = $travelerName;
        return $this;
    }
    /**
     * Get ItineraryName value
     * @return string|null
     */
    public function getItineraryName()
    {
        return $this->ItineraryName;
    }
    /**
     * Set ItineraryName value
     * @param string $itineraryName
     * @return \StructType\GlobalReservation
     */
    public function setItineraryName($itineraryName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($itineraryName) && strlen($itineraryName) > 64) || (is_array($itineraryName) && count($itineraryName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($itineraryName) ? strlen($itineraryName) : count($itineraryName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($itineraryName) && strlen($itineraryName) < 0) || (is_array($itineraryName) && count($itineraryName) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($itineraryName) && !is_string($itineraryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itineraryName)), __LINE__);
        }
        $this->ItineraryName = $itineraryName;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\GlobalReservation
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GlobalReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
