<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fulfillment StructType
 * Meta informations extracted from the WSDL
 * - documentation: All payment information relevant to a booking request. | All payment information relevant to a booking request.
 * @subpackage Structs
 */
class Fulfillment extends AbstractStructBase
{
    /**
     * The PaymentDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentDetails
     */
    public $PaymentDetails;
    /**
     * The DeliveryAddress
     * Meta informations extracted from the WSDL
     * - documentation: Ticket delivery information for the booking request. | The postal address where the ticketing fulfillment (i.e., ticket, receipt) will be sent.
     * - minOccurs: 0
     * @var mixed
     */
    public $DeliveryAddress;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Purchaser name details
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $Name;
    /**
     * The Receipt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Receipt
     */
    public $Receipt;
    /**
     * Constructor method for Fulfillment
     * @uses Fulfillment::setPaymentDetails()
     * @uses Fulfillment::setDeliveryAddress()
     * @uses Fulfillment::setName()
     * @uses Fulfillment::setReceipt()
     * @param \StructType\PaymentDetails $paymentDetails
     * @param mixed $deliveryAddress
     * @param \StructType\PersonNameType $name
     * @param \StructType\Receipt $receipt
     */
    public function __construct(\StructType\PaymentDetails $paymentDetails = null, $deliveryAddress = null, \StructType\PersonNameType $name = null, \StructType\Receipt $receipt = null)
    {
        $this
            ->setPaymentDetails($paymentDetails)
            ->setDeliveryAddress($deliveryAddress)
            ->setName($name)
            ->setReceipt($receipt);
    }
    /**
     * Get PaymentDetails value
     * @return \StructType\PaymentDetails|null
     */
    public function getPaymentDetails()
    {
        return $this->PaymentDetails;
    }
    /**
     * Set PaymentDetails value
     * @param \StructType\PaymentDetails $paymentDetails
     * @return \StructType\Fulfillment
     */
    public function setPaymentDetails(\StructType\PaymentDetails $paymentDetails = null)
    {
        $this->PaymentDetails = $paymentDetails;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return mixed|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param mixed $deliveryAddress
     * @return \StructType\Fulfillment
     */
    public function setDeliveryAddress($deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\PersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\PersonNameType $name
     * @return \StructType\Fulfillment
     */
    public function setName(\StructType\PersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Receipt value
     * @return \StructType\Receipt|null
     */
    public function getReceipt()
    {
        return $this->Receipt;
    }
    /**
     * Set Receipt value
     * @param \StructType\Receipt $receipt
     * @return \StructType\Fulfillment
     */
    public function setReceipt(\StructType\Receipt $receipt = null)
    {
        $this->Receipt = $receipt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Fulfillment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
