<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightTypePref StructType
 * Meta informations extracted from the WSDL
 * - documentation: Flight Type Preferences to qualify Air Schedule request. | Indicates preferred flight characteristics to be used in a search (e.g., connections, stopovers). | Defines preferred flight characteristics to be used in a search.
 * @subpackage Structs
 */
class FlightTypePref extends AbstractStructBase
{
    /**
     * The FlightType
     * Meta informations extracted from the WSDL
     * - documentation: Indicates type of stops preferred (Nonstop, Direct, Connection). | Indicates type of stops preferred (Nonstop, Direct, Connection).
     * @var string
     */
    public $FlightType;
    /**
     * The MaxConnections
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that if connection is chosen, then this attribute defines the maximum number of connections preferred. | Indicates that if connection is chosen, then this attribute defines the maximum number of connections preferred.
     * @var int
     */
    public $MaxConnections;
    /**
     * The NonScheduledFltInfo
     * @var string
     */
    public $NonScheduledFltInfo;
    /**
     * The BackhaulIndicator
     * Meta informations extracted from the WSDL
     * - documentation: If true, include connections where one of the enroute stops is the same as the initial board point or the final off point of the flight. | If true, include connections where one of the enroute stops is the same as the initial board
     * point or the final off point of the flight.
     * @var bool
     */
    public $BackhaulIndicator;
    /**
     * The GroundTransportIndicator
     * Meta informations extracted from the WSDL
     * - documentation: If true, include flights that include at least one leg that is ground transportation. | If true, include flights that include at least one leg that is ground transportation.
     * @var bool
     */
    public $GroundTransportIndicator;
    /**
     * The DirectAndNonStopOnlyInd
     * Meta informations extracted from the WSDL
     * - documentation: If true, direct and non-stop flights are requested. | If true, direct and non-stop flights are requested.
     * @var bool
     */
    public $DirectAndNonStopOnlyInd;
    /**
     * The NonStopsOnlyInd
     * Meta informations extracted from the WSDL
     * - documentation: If true, only non-stop flights are requested. | If true, only non-stop flights are requested.
     * @var bool
     */
    public $NonStopsOnlyInd;
    /**
     * The OnlineConnectionsOnlyInd
     * Meta informations extracted from the WSDL
     * - documentation: If true, only online connection flights are requested (i.e., same marketing airline). | If true, only online connection flights are requested (i.e., same marketing airline).
     * @var bool
     */
    public $OnlineConnectionsOnlyInd;
    /**
     * The RoutingType
     * @var string
     */
    public $RoutingType;
    /**
     * Constructor method for FlightTypePref
     * @uses FlightTypePref::setFlightType()
     * @uses FlightTypePref::setMaxConnections()
     * @uses FlightTypePref::setNonScheduledFltInfo()
     * @uses FlightTypePref::setBackhaulIndicator()
     * @uses FlightTypePref::setGroundTransportIndicator()
     * @uses FlightTypePref::setDirectAndNonStopOnlyInd()
     * @uses FlightTypePref::setNonStopsOnlyInd()
     * @uses FlightTypePref::setOnlineConnectionsOnlyInd()
     * @uses FlightTypePref::setRoutingType()
     * @param string $flightType
     * @param int $maxConnections
     * @param string $nonScheduledFltInfo
     * @param bool $backhaulIndicator
     * @param bool $groundTransportIndicator
     * @param bool $directAndNonStopOnlyInd
     * @param bool $nonStopsOnlyInd
     * @param bool $onlineConnectionsOnlyInd
     * @param string $routingType
     */
    public function __construct($flightType = null, $maxConnections = null, $nonScheduledFltInfo = null, $backhaulIndicator = null, $groundTransportIndicator = null, $directAndNonStopOnlyInd = null, $nonStopsOnlyInd = null, $onlineConnectionsOnlyInd = null, $routingType = null)
    {
        $this
            ->setFlightType($flightType)
            ->setMaxConnections($maxConnections)
            ->setNonScheduledFltInfo($nonScheduledFltInfo)
            ->setBackhaulIndicator($backhaulIndicator)
            ->setGroundTransportIndicator($groundTransportIndicator)
            ->setDirectAndNonStopOnlyInd($directAndNonStopOnlyInd)
            ->setNonStopsOnlyInd($nonStopsOnlyInd)
            ->setOnlineConnectionsOnlyInd($onlineConnectionsOnlyInd)
            ->setRoutingType($routingType);
    }
    /**
     * Get FlightType value
     * @return string|null
     */
    public function getFlightType()
    {
        return $this->FlightType;
    }
    /**
     * Set FlightType value
     * @param string $flightType
     * @return \StructType\FlightTypePref
     */
    public function setFlightType($flightType = null)
    {
        // validation for constraint: string
        if (!is_null($flightType) && !is_string($flightType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightType)), __LINE__);
        }
        $this->FlightType = $flightType;
        return $this;
    }
    /**
     * Get MaxConnections value
     * @return int|null
     */
    public function getMaxConnections()
    {
        return $this->MaxConnections;
    }
    /**
     * Set MaxConnections value
     * @param int $maxConnections
     * @return \StructType\FlightTypePref
     */
    public function setMaxConnections($maxConnections = null)
    {
        // validation for constraint: int
        if (!is_null($maxConnections) && !is_numeric($maxConnections)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxConnections)), __LINE__);
        }
        $this->MaxConnections = $maxConnections;
        return $this;
    }
    /**
     * Get NonScheduledFltInfo value
     * @return string|null
     */
    public function getNonScheduledFltInfo()
    {
        return $this->NonScheduledFltInfo;
    }
    /**
     * Set NonScheduledFltInfo value
     * @param string $nonScheduledFltInfo
     * @return \StructType\FlightTypePref
     */
    public function setNonScheduledFltInfo($nonScheduledFltInfo = null)
    {
        // validation for constraint: string
        if (!is_null($nonScheduledFltInfo) && !is_string($nonScheduledFltInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nonScheduledFltInfo)), __LINE__);
        }
        $this->NonScheduledFltInfo = $nonScheduledFltInfo;
        return $this;
    }
    /**
     * Get BackhaulIndicator value
     * @return bool|null
     */
    public function getBackhaulIndicator()
    {
        return $this->BackhaulIndicator;
    }
    /**
     * Set BackhaulIndicator value
     * @param bool $backhaulIndicator
     * @return \StructType\FlightTypePref
     */
    public function setBackhaulIndicator($backhaulIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($backhaulIndicator) && !is_bool($backhaulIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($backhaulIndicator)), __LINE__);
        }
        $this->BackhaulIndicator = $backhaulIndicator;
        return $this;
    }
    /**
     * Get GroundTransportIndicator value
     * @return bool|null
     */
    public function getGroundTransportIndicator()
    {
        return $this->GroundTransportIndicator;
    }
    /**
     * Set GroundTransportIndicator value
     * @param bool $groundTransportIndicator
     * @return \StructType\FlightTypePref
     */
    public function setGroundTransportIndicator($groundTransportIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($groundTransportIndicator) && !is_bool($groundTransportIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($groundTransportIndicator)), __LINE__);
        }
        $this->GroundTransportIndicator = $groundTransportIndicator;
        return $this;
    }
    /**
     * Get DirectAndNonStopOnlyInd value
     * @return bool|null
     */
    public function getDirectAndNonStopOnlyInd()
    {
        return $this->DirectAndNonStopOnlyInd;
    }
    /**
     * Set DirectAndNonStopOnlyInd value
     * @param bool $directAndNonStopOnlyInd
     * @return \StructType\FlightTypePref
     */
    public function setDirectAndNonStopOnlyInd($directAndNonStopOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($directAndNonStopOnlyInd) && !is_bool($directAndNonStopOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($directAndNonStopOnlyInd)), __LINE__);
        }
        $this->DirectAndNonStopOnlyInd = $directAndNonStopOnlyInd;
        return $this;
    }
    /**
     * Get NonStopsOnlyInd value
     * @return bool|null
     */
    public function getNonStopsOnlyInd()
    {
        return $this->NonStopsOnlyInd;
    }
    /**
     * Set NonStopsOnlyInd value
     * @param bool $nonStopsOnlyInd
     * @return \StructType\FlightTypePref
     */
    public function setNonStopsOnlyInd($nonStopsOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonStopsOnlyInd) && !is_bool($nonStopsOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonStopsOnlyInd)), __LINE__);
        }
        $this->NonStopsOnlyInd = $nonStopsOnlyInd;
        return $this;
    }
    /**
     * Get OnlineConnectionsOnlyInd value
     * @return bool|null
     */
    public function getOnlineConnectionsOnlyInd()
    {
        return $this->OnlineConnectionsOnlyInd;
    }
    /**
     * Set OnlineConnectionsOnlyInd value
     * @param bool $onlineConnectionsOnlyInd
     * @return \StructType\FlightTypePref
     */
    public function setOnlineConnectionsOnlyInd($onlineConnectionsOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlineConnectionsOnlyInd) && !is_bool($onlineConnectionsOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($onlineConnectionsOnlyInd)), __LINE__);
        }
        $this->OnlineConnectionsOnlyInd = $onlineConnectionsOnlyInd;
        return $this;
    }
    /**
     * Get RoutingType value
     * @return string|null
     */
    public function getRoutingType()
    {
        return $this->RoutingType;
    }
    /**
     * Set RoutingType value
     * @param string $routingType
     * @return \StructType\FlightTypePref
     */
    public function setRoutingType($routingType = null)
    {
        // validation for constraint: string
        if (!is_null($routingType) && !is_string($routingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routingType)), __LINE__);
        }
        $this->RoutingType = $routingType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightTypePref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
