<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegmentBaseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Construct for holding a flight segment availability object.
 * @subpackage Structs
 */
class FlightSegmentBaseType extends AbstractStructBase
{
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The DepartureAirport
     * @var \StructType\DepartureAirport
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * @var \StructType\ArrivalAirport
     */
    public $ArrivalAirport;
    /**
     * The OperatingAirline
     * Meta informations extracted from the WSDL
     * - documentation: The operating airline of the flight if it is a codeshare flight.
     * - minOccurs: 0
     * @var mixed
     */
    public $OperatingAirline;
    /**
     * The Equipment
     * Meta informations extracted from the WSDL
     * - documentation: The type of equipment used for the flight..
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Equipment;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The StopQuantity
     * Meta informations extracted from the WSDL
     * - documentation: The number of stops the flight makes
     * - use: optional
     * @var int
     */
    public $StopQuantity;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The InfoSource
     * Meta informations extracted from the WSDL
     * - documentation: Used to specify the source of the data being exchanged as determined by trading partners.
     * - use: optional
     * @var string
     */
    public $InfoSource;
    /**
     * The SegmentCode
     * Meta informations extracted from the WSDL
     * - documentation: Used to specify the segment code.
     * - use: optional
     * @var string
     */
    public $SegmentCode;
    /**
     * The returnFlag
     * Meta informations extracted from the WSDL
     * - documentation: Used to specify the return segments.
     * - use: optional
     * @var bool
     */
    public $returnFlag;
    /**
     * Constructor method for FlightSegmentBaseType
     * @uses FlightSegmentBaseType::setDepartureDateTime()
     * @uses FlightSegmentBaseType::setDepartureAirport()
     * @uses FlightSegmentBaseType::setArrivalAirport()
     * @uses FlightSegmentBaseType::setOperatingAirline()
     * @uses FlightSegmentBaseType::setEquipment()
     * @uses FlightSegmentBaseType::setArrivalDateTime()
     * @uses FlightSegmentBaseType::setStopQuantity()
     * @uses FlightSegmentBaseType::setRPH()
     * @uses FlightSegmentBaseType::setInfoSource()
     * @uses FlightSegmentBaseType::setSegmentCode()
     * @uses FlightSegmentBaseType::setReturnFlag()
     * @param string $departureDateTime
     * @param \StructType\DepartureAirport $departureAirport
     * @param \StructType\ArrivalAirport $arrivalAirport
     * @param mixed $operatingAirline
     * @param mixed[] $equipment
     * @param string $arrivalDateTime
     * @param int $stopQuantity
     * @param string $rPH
     * @param string $infoSource
     * @param string $segmentCode
     * @param bool $returnFlag
     */
    public function __construct($departureDateTime = null, \StructType\DepartureAirport $departureAirport = null, \StructType\ArrivalAirport $arrivalAirport = null, $operatingAirline = null, array $equipment = array(), $arrivalDateTime = null, $stopQuantity = null, $rPH = null, $infoSource = null, $segmentCode = null, $returnFlag = null)
    {
        $this
            ->setDepartureDateTime($departureDateTime)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setOperatingAirline($operatingAirline)
            ->setEquipment($equipment)
            ->setArrivalDateTime($arrivalDateTime)
            ->setStopQuantity($stopQuantity)
            ->setRPH($rPH)
            ->setInfoSource($infoSource)
            ->setSegmentCode($segmentCode)
            ->setReturnFlag($returnFlag);
    }
    /**
     * Get DepartureDateTime value
     * @return string
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \StructType\FlightSegmentBaseType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \StructType\DepartureAirport|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \StructType\DepartureAirport $departureAirport
     * @return \StructType\FlightSegmentBaseType
     */
    public function setDepartureAirport(\StructType\DepartureAirport $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \StructType\ArrivalAirport|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \StructType\ArrivalAirport $arrivalAirport
     * @return \StructType\FlightSegmentBaseType
     */
    public function setArrivalAirport(\StructType\ArrivalAirport $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return mixed|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @param mixed $operatingAirline
     * @return \StructType\FlightSegmentBaseType
     */
    public function setOperatingAirline($operatingAirline = null)
    {
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Get Equipment value
     * @return mixed[]|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @throws \InvalidArgumentException
     * @param mixed[] $equipment
     * @return \StructType\FlightSegmentBaseType
     */
    public function setEquipment(array $equipment = array())
    {
        foreach ($equipment as $flightSegmentBaseTypeEquipmentItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The Equipment property can only contain items of anyType, "%s" given', is_object($flightSegmentBaseTypeEquipmentItem) ? get_class($flightSegmentBaseTypeEquipmentItem) : gettype($flightSegmentBaseTypeEquipmentItem)), __LINE__);
            }
        }
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Add item to Equipment value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\FlightSegmentBaseType
     */
    public function addToEquipment($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The Equipment property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Equipment[] = $item;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\FlightSegmentBaseType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get StopQuantity value
     * @return int|null
     */
    public function getStopQuantity()
    {
        return $this->StopQuantity;
    }
    /**
     * Set StopQuantity value
     * @param int $stopQuantity
     * @return \StructType\FlightSegmentBaseType
     */
    public function setStopQuantity($stopQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($stopQuantity) && !is_numeric($stopQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stopQuantity)), __LINE__);
        }
        $this->StopQuantity = $stopQuantity;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\FlightSegmentBaseType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\FlightSegmentBaseType
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get SegmentCode value
     * @return string|null
     */
    public function getSegmentCode()
    {
        return $this->SegmentCode;
    }
    /**
     * Set SegmentCode value
     * @param string $segmentCode
     * @return \StructType\FlightSegmentBaseType
     */
    public function setSegmentCode($segmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentCode) && !is_string($segmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentCode)), __LINE__);
        }
        $this->SegmentCode = $segmentCode;
        return $this;
    }
    /**
     * Get returnFlag value
     * @return bool|null
     */
    public function getReturnFlag()
    {
        return $this->returnFlag;
    }
    /**
     * Set returnFlag value
     * @param bool $returnFlag
     * @return \StructType\FlightSegmentBaseType
     */
    public function setReturnFlag($returnFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnFlag) && !is_bool($returnFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnFlag)), __LINE__);
        }
        $this->returnFlag = $returnFlag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightSegmentBaseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
