<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlexiOperationsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: The allowing flexibility types.
 * @subpackage Structs
 */
class FlexiOperationsType extends AbstractStructBase
{
    /**
     * The AllowedOperationName
     * Meta informations extracted from the WSDL
     * - documentation: The allowed operation name available with the flexibility.
     * - use: optional
     * @var string
     */
    public $AllowedOperationName;
    /**
     * The NumberOfAllowedOperations
     * Meta informations extracted from the WSDL
     * - documentation: The number of times the operation is allowed.
     * - use: optional
     * @var int
     */
    public $NumberOfAllowedOperations;
    /**
     * The FlexiOperationCutoverTimeInMinutes
     * Meta informations extracted from the WSDL
     * - documentation: The cutover time of the flexibility operation.
     * - use: optional
     * @var int
     */
    public $FlexiOperationCutoverTimeInMinutes;
    /**
     * Constructor method for FlexiOperationsType
     * @uses FlexiOperationsType::setAllowedOperationName()
     * @uses FlexiOperationsType::setNumberOfAllowedOperations()
     * @uses FlexiOperationsType::setFlexiOperationCutoverTimeInMinutes()
     * @param string $allowedOperationName
     * @param int $numberOfAllowedOperations
     * @param int $flexiOperationCutoverTimeInMinutes
     */
    public function __construct($allowedOperationName = null, $numberOfAllowedOperations = null, $flexiOperationCutoverTimeInMinutes = null)
    {
        $this
            ->setAllowedOperationName($allowedOperationName)
            ->setNumberOfAllowedOperations($numberOfAllowedOperations)
            ->setFlexiOperationCutoverTimeInMinutes($flexiOperationCutoverTimeInMinutes);
    }
    /**
     * Get AllowedOperationName value
     * @return string|null
     */
    public function getAllowedOperationName()
    {
        return $this->AllowedOperationName;
    }
    /**
     * Set AllowedOperationName value
     * @param string $allowedOperationName
     * @return \StructType\FlexiOperationsType
     */
    public function setAllowedOperationName($allowedOperationName = null)
    {
        // validation for constraint: string
        if (!is_null($allowedOperationName) && !is_string($allowedOperationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowedOperationName)), __LINE__);
        }
        $this->AllowedOperationName = $allowedOperationName;
        return $this;
    }
    /**
     * Get NumberOfAllowedOperations value
     * @return int|null
     */
    public function getNumberOfAllowedOperations()
    {
        return $this->NumberOfAllowedOperations;
    }
    /**
     * Set NumberOfAllowedOperations value
     * @param int $numberOfAllowedOperations
     * @return \StructType\FlexiOperationsType
     */
    public function setNumberOfAllowedOperations($numberOfAllowedOperations = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAllowedOperations) && !is_numeric($numberOfAllowedOperations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfAllowedOperations)), __LINE__);
        }
        $this->NumberOfAllowedOperations = $numberOfAllowedOperations;
        return $this;
    }
    /**
     * Get FlexiOperationCutoverTimeInMinutes value
     * @return int|null
     */
    public function getFlexiOperationCutoverTimeInMinutes()
    {
        return $this->FlexiOperationCutoverTimeInMinutes;
    }
    /**
     * Set FlexiOperationCutoverTimeInMinutes value
     * @param int $flexiOperationCutoverTimeInMinutes
     * @return \StructType\FlexiOperationsType
     */
    public function setFlexiOperationCutoverTimeInMinutes($flexiOperationCutoverTimeInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($flexiOperationCutoverTimeInMinutes) && !is_numeric($flexiOperationCutoverTimeInMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($flexiOperationCutoverTimeInMinutes)), __LINE__);
        }
        $this->FlexiOperationCutoverTimeInMinutes = $flexiOperationCutoverTimeInMinutes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlexiOperationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
