<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlexiFareType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Information regarding the flexible fare.
 * @subpackage Structs
 */
class FlexiFareType extends AbstractStructBase
{
    /**
     * The FlexiFareAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FlexiFareAmount
     */
    public $FlexiFareAmount;
    /**
     * The FlexibilityDescription
     * Meta informations extracted from the WSDL
     * - documentation: The description of the available flexi fare.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlexibilityDescription;
    /**
     * The AllowedFlexiOperations
     * @var \StructType\AllowedFlexiOperations
     */
    public $AllowedFlexiOperations;
    /**
     * The PerPaxFlexifareBDS
     * @var \StructType\PerPaxFlexifareBDS
     */
    public $PerPaxFlexifareBDS;
    /**
     * The FlexiRuleComment
     * Meta informations extracted from the WSDL
     * - documentation: The flexi rule comment of the available flexi fare.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlexiRuleComment;
    /**
     * The FlexiRuleCode
     * Meta informations extracted from the WSDL
     * - documentation: The flexi rule code of the available flexi fare.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlexiRuleCode;
    /**
     * The ApplicableJourneyType
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the applicable journey type of the flexi fare.
     * - use: optional
     * @var string
     */
    public $ApplicableJourneyType;
    /**
     * Constructor method for FlexiFareType
     * @uses FlexiFareType::setFlexiFareAmount()
     * @uses FlexiFareType::setFlexibilityDescription()
     * @uses FlexiFareType::setAllowedFlexiOperations()
     * @uses FlexiFareType::setPerPaxFlexifareBDS()
     * @uses FlexiFareType::setFlexiRuleComment()
     * @uses FlexiFareType::setFlexiRuleCode()
     * @uses FlexiFareType::setApplicableJourneyType()
     * @param \StructType\FlexiFareAmount $flexiFareAmount
     * @param string $flexibilityDescription
     * @param \StructType\AllowedFlexiOperations $allowedFlexiOperations
     * @param \StructType\PerPaxFlexifareBDS $perPaxFlexifareBDS
     * @param string $flexiRuleComment
     * @param string $flexiRuleCode
     * @param string $applicableJourneyType
     */
    public function __construct(\StructType\FlexiFareAmount $flexiFareAmount = null, $flexibilityDescription = null, \StructType\AllowedFlexiOperations $allowedFlexiOperations = null, \StructType\PerPaxFlexifareBDS $perPaxFlexifareBDS = null, $flexiRuleComment = null, $flexiRuleCode = null, $applicableJourneyType = null)
    {
        $this
            ->setFlexiFareAmount($flexiFareAmount)
            ->setFlexibilityDescription($flexibilityDescription)
            ->setAllowedFlexiOperations($allowedFlexiOperations)
            ->setPerPaxFlexifareBDS($perPaxFlexifareBDS)
            ->setFlexiRuleComment($flexiRuleComment)
            ->setFlexiRuleCode($flexiRuleCode)
            ->setApplicableJourneyType($applicableJourneyType);
    }
    /**
     * Get FlexiFareAmount value
     * @return \StructType\FlexiFareAmount|null
     */
    public function getFlexiFareAmount()
    {
        return $this->FlexiFareAmount;
    }
    /**
     * Set FlexiFareAmount value
     * @param \StructType\FlexiFareAmount $flexiFareAmount
     * @return \StructType\FlexiFareType
     */
    public function setFlexiFareAmount(\StructType\FlexiFareAmount $flexiFareAmount = null)
    {
        $this->FlexiFareAmount = $flexiFareAmount;
        return $this;
    }
    /**
     * Get FlexibilityDescription value
     * @return string|null
     */
    public function getFlexibilityDescription()
    {
        return $this->FlexibilityDescription;
    }
    /**
     * Set FlexibilityDescription value
     * @param string $flexibilityDescription
     * @return \StructType\FlexiFareType
     */
    public function setFlexibilityDescription($flexibilityDescription = null)
    {
        // validation for constraint: string
        if (!is_null($flexibilityDescription) && !is_string($flexibilityDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flexibilityDescription)), __LINE__);
        }
        $this->FlexibilityDescription = $flexibilityDescription;
        return $this;
    }
    /**
     * Get AllowedFlexiOperations value
     * @return \StructType\AllowedFlexiOperations|null
     */
    public function getAllowedFlexiOperations()
    {
        return $this->AllowedFlexiOperations;
    }
    /**
     * Set AllowedFlexiOperations value
     * @param \StructType\AllowedFlexiOperations $allowedFlexiOperations
     * @return \StructType\FlexiFareType
     */
    public function setAllowedFlexiOperations(\StructType\AllowedFlexiOperations $allowedFlexiOperations = null)
    {
        $this->AllowedFlexiOperations = $allowedFlexiOperations;
        return $this;
    }
    /**
     * Get PerPaxFlexifareBDS value
     * @return \StructType\PerPaxFlexifareBDS|null
     */
    public function getPerPaxFlexifareBDS()
    {
        return $this->PerPaxFlexifareBDS;
    }
    /**
     * Set PerPaxFlexifareBDS value
     * @param \StructType\PerPaxFlexifareBDS $perPaxFlexifareBDS
     * @return \StructType\FlexiFareType
     */
    public function setPerPaxFlexifareBDS(\StructType\PerPaxFlexifareBDS $perPaxFlexifareBDS = null)
    {
        $this->PerPaxFlexifareBDS = $perPaxFlexifareBDS;
        return $this;
    }
    /**
     * Get FlexiRuleComment value
     * @return string|null
     */
    public function getFlexiRuleComment()
    {
        return $this->FlexiRuleComment;
    }
    /**
     * Set FlexiRuleComment value
     * @param string $flexiRuleComment
     * @return \StructType\FlexiFareType
     */
    public function setFlexiRuleComment($flexiRuleComment = null)
    {
        // validation for constraint: string
        if (!is_null($flexiRuleComment) && !is_string($flexiRuleComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flexiRuleComment)), __LINE__);
        }
        $this->FlexiRuleComment = $flexiRuleComment;
        return $this;
    }
    /**
     * Get FlexiRuleCode value
     * @return string|null
     */
    public function getFlexiRuleCode()
    {
        return $this->FlexiRuleCode;
    }
    /**
     * Set FlexiRuleCode value
     * @param string $flexiRuleCode
     * @return \StructType\FlexiFareType
     */
    public function setFlexiRuleCode($flexiRuleCode = null)
    {
        // validation for constraint: string
        if (!is_null($flexiRuleCode) && !is_string($flexiRuleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flexiRuleCode)), __LINE__);
        }
        $this->FlexiRuleCode = $flexiRuleCode;
        return $this;
    }
    /**
     * Get ApplicableJourneyType value
     * @return string|null
     */
    public function getApplicableJourneyType()
    {
        return $this->ApplicableJourneyType;
    }
    /**
     * Set ApplicableJourneyType value
     * @param string $applicableJourneyType
     * @return \StructType\FlexiFareType
     */
    public function setApplicableJourneyType($applicableJourneyType = null)
    {
        // validation for constraint: string
        if (!is_null($applicableJourneyType) && !is_string($applicableJourneyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicableJourneyType)), __LINE__);
        }
        $this->ApplicableJourneyType = $applicableJourneyType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlexiFareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
