<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareTypePrefType StructType
 * @subpackage Structs
 */
class FareTypePrefType extends AbstractStructBase
{
    /**
     * The FareType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $FareType;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for FareTypePrefType
     * @uses FareTypePrefType::setFareType()
     * @uses FareTypePrefType::setPreferLevel()
     * @param string $fareType
     * @param string $preferLevel
     */
    public function __construct($fareType = null, $preferLevel = null)
    {
        $this
            ->setFareType($fareType)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get FareType value
     * @return string
     */
    public function getFareType()
    {
        return $this->FareType;
    }
    /**
     * Set FareType value
     * @param string $fareType
     * @return \StructType\FareTypePrefType
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareType)), __LINE__);
        }
        $this->FareType = $fareType;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @param string $preferLevel
     * @return \StructType\FareTypePrefType
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: string
        if (!is_null($preferLevel) && !is_string($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferLevel)), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareTypePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
