<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Rules for this priced option.
 * @subpackage Structs
 */
class FareInfoType extends AbstractStructBase
{
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: Departure Date for this priced fare
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The FareReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * @var \StructType\FareReference[]
     */
    public $FareReference;
    /**
     * The RuleInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RuleInfo
     */
    public $RuleInfo;
    /**
     * The FilingAirline
     * Meta informations extracted from the WSDL
     * - documentation: The airline that filed the fare(s).
     * - minOccurs: 0
     * @var mixed
     */
    public $FilingAirline;
    /**
     * The MarketingAirline
     * Meta informations extracted from the WSDL
     * - documentation: The marketing airline.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MarketingAirline;
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - documentation: Departure point of flight segment.
     * @var mixed
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - documentation: Arrival point of flight segment.
     * @var mixed
     */
    public $ArrivalAirport;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Date[]
     */
    public $Date;
    /**
     * The FareInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\FareInfo[]
     */
    public $FareInfo;
    /**
     * The FareRuleReference
     * Meta informations extracted from the WSDL
     * - documentation: Comments for the fare
     * @var string
     */
    public $FareRuleReference;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: The ISO 4217 currency code associated with the fare rule information.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The TariffNumber
     * Meta informations extracted from the WSDL
     * - documentation: The tariff number for the rule.
     * - use: optional
     * @var string
     */
    public $TariffNumber;
    /**
     * The RuleNumber
     * Meta informations extracted from the WSDL
     * - documentation: The number associated with the fare rule.
     * - use: optional
     * @var string
     */
    public $RuleNumber;
    /**
     * The adultFare
     * Meta informations extracted from the WSDL
     * - documentation: Adult Fare
     * - use: optional
     * @var string
     */
    public $adultFare;
    /**
     * The childFare
     * Meta informations extracted from the WSDL
     * - documentation: Child Fare
     * - use: optional
     * @var string
     */
    public $childFare;
    /**
     * The infantFare
     * Meta informations extracted from the WSDL
     * - documentation: Infant Fare
     * - use: optional
     * @var string
     */
    public $infantFare;
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - documentation: Fare Basis Code
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * The SegmentCode
     * Meta informations extracted from the WSDL
     * - documentation: The DepartureAirport and the ArrivalAirport of the reservation
     * - use: optional
     * @var string
     */
    public $SegmentCode;
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - documentation: Booking class of the reservation
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The FareRuleInfo
     * Meta informations extracted from the WSDL
     * - documentation: Fare rule for the reservation
     * - use: optional
     * @var string
     */
    public $FareRuleInfo;
    /**
     * Constructor method for FareInfoType
     * @uses FareInfoType::setDepartureDate()
     * @uses FareInfoType::setFareReference()
     * @uses FareInfoType::setRuleInfo()
     * @uses FareInfoType::setFilingAirline()
     * @uses FareInfoType::setMarketingAirline()
     * @uses FareInfoType::setDepartureAirport()
     * @uses FareInfoType::setArrivalAirport()
     * @uses FareInfoType::setDate()
     * @uses FareInfoType::setFareInfo()
     * @uses FareInfoType::setFareRuleReference()
     * @uses FareInfoType::setCurrencyCode()
     * @uses FareInfoType::setTariffNumber()
     * @uses FareInfoType::setRuleNumber()
     * @uses FareInfoType::setAdultFare()
     * @uses FareInfoType::setChildFare()
     * @uses FareInfoType::setInfantFare()
     * @uses FareInfoType::setFareBasisCode()
     * @uses FareInfoType::setSegmentCode()
     * @uses FareInfoType::setResBookDesigCode()
     * @uses FareInfoType::setFareRuleInfo()
     * @param string $departureDate
     * @param \StructType\FareReference[] $fareReference
     * @param \StructType\RuleInfo $ruleInfo
     * @param mixed $filingAirline
     * @param mixed[] $marketingAirline
     * @param mixed $departureAirport
     * @param mixed $arrivalAirport
     * @param \StructType\Date[] $date
     * @param \StructType\FareInfo[] $fareInfo
     * @param string $fareRuleReference
     * @param string $currencyCode
     * @param string $tariffNumber
     * @param string $ruleNumber
     * @param string $adultFare
     * @param string $childFare
     * @param string $infantFare
     * @param string $fareBasisCode
     * @param string $segmentCode
     * @param string $resBookDesigCode
     * @param string $fareRuleInfo
     */
    public function __construct($departureDate = null, array $fareReference = array(), \StructType\RuleInfo $ruleInfo = null, $filingAirline = null, array $marketingAirline = array(), $departureAirport = null, $arrivalAirport = null, array $date = array(), array $fareInfo = array(), $fareRuleReference = null, $currencyCode = null, $tariffNumber = null, $ruleNumber = null, $adultFare = null, $childFare = null, $infantFare = null, $fareBasisCode = null, $segmentCode = null, $resBookDesigCode = null, $fareRuleInfo = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setFareReference($fareReference)
            ->setRuleInfo($ruleInfo)
            ->setFilingAirline($filingAirline)
            ->setMarketingAirline($marketingAirline)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setDate($date)
            ->setFareInfo($fareInfo)
            ->setFareRuleReference($fareRuleReference)
            ->setCurrencyCode($currencyCode)
            ->setTariffNumber($tariffNumber)
            ->setRuleNumber($ruleNumber)
            ->setAdultFare($adultFare)
            ->setChildFare($childFare)
            ->setInfantFare($infantFare)
            ->setFareBasisCode($fareBasisCode)
            ->setSegmentCode($segmentCode)
            ->setResBookDesigCode($resBookDesigCode)
            ->setFareRuleInfo($fareRuleInfo);
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\FareInfoType
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get FareReference value
     * @return \StructType\FareReference[]|null
     */
    public function getFareReference()
    {
        return $this->FareReference;
    }
    /**
     * Set FareReference value
     * @throws \InvalidArgumentException
     * @param \StructType\FareReference[] $fareReference
     * @return \StructType\FareInfoType
     */
    public function setFareReference(array $fareReference = array())
    {
        foreach ($fareReference as $fareInfoTypeFareReferenceItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeFareReferenceItem instanceof \StructType\FareReference) {
                throw new \InvalidArgumentException(sprintf('The FareReference property can only contain items of \StructType\FareReference, "%s" given', is_object($fareInfoTypeFareReferenceItem) ? get_class($fareInfoTypeFareReferenceItem) : gettype($fareInfoTypeFareReferenceItem)), __LINE__);
            }
        }
        $this->FareReference = $fareReference;
        return $this;
    }
    /**
     * Add item to FareReference value
     * @throws \InvalidArgumentException
     * @param \StructType\FareReference $item
     * @return \StructType\FareInfoType
     */
    public function addToFareReference(\StructType\FareReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareReference) {
            throw new \InvalidArgumentException(sprintf('The FareReference property can only contain items of \StructType\FareReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareReference[] = $item;
        return $this;
    }
    /**
     * Get RuleInfo value
     * @return \StructType\RuleInfo|null
     */
    public function getRuleInfo()
    {
        return $this->RuleInfo;
    }
    /**
     * Set RuleInfo value
     * @param \StructType\RuleInfo $ruleInfo
     * @return \StructType\FareInfoType
     */
    public function setRuleInfo(\StructType\RuleInfo $ruleInfo = null)
    {
        $this->RuleInfo = $ruleInfo;
        return $this;
    }
    /**
     * Get FilingAirline value
     * @return mixed|null
     */
    public function getFilingAirline()
    {
        return $this->FilingAirline;
    }
    /**
     * Set FilingAirline value
     * @param mixed $filingAirline
     * @return \StructType\FareInfoType
     */
    public function setFilingAirline($filingAirline = null)
    {
        $this->FilingAirline = $filingAirline;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return mixed[]|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @throws \InvalidArgumentException
     * @param mixed[] $marketingAirline
     * @return \StructType\FareInfoType
     */
    public function setMarketingAirline(array $marketingAirline = array())
    {
        foreach ($marketingAirline as $fareInfoTypeMarketingAirlineItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The MarketingAirline property can only contain items of anyType, "%s" given', is_object($fareInfoTypeMarketingAirlineItem) ? get_class($fareInfoTypeMarketingAirlineItem) : gettype($fareInfoTypeMarketingAirlineItem)), __LINE__);
            }
        }
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Add item to MarketingAirline value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\FareInfoType
     */
    public function addToMarketingAirline($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The MarketingAirline property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MarketingAirline[] = $item;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return mixed|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param mixed $departureAirport
     * @return \StructType\FareInfoType
     */
    public function setDepartureAirport($departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return mixed|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param mixed $arrivalAirport
     * @return \StructType\FareInfoType
     */
    public function setArrivalAirport($arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get Date value
     * @return \StructType\Date[]|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @throws \InvalidArgumentException
     * @param \StructType\Date[] $date
     * @return \StructType\FareInfoType
     */
    public function setDate(array $date = array())
    {
        foreach ($date as $fareInfoTypeDateItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeDateItem instanceof \StructType\Date) {
                throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \StructType\Date, "%s" given', is_object($fareInfoTypeDateItem) ? get_class($fareInfoTypeDateItem) : gettype($fareInfoTypeDateItem)), __LINE__);
            }
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Add item to Date value
     * @throws \InvalidArgumentException
     * @param \StructType\Date $item
     * @return \StructType\FareInfoType
     */
    public function addToDate(\StructType\Date $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Date) {
            throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \StructType\Date, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Date[] = $item;
        return $this;
    }
    /**
     * Get FareInfo value
     * @return \StructType\FareInfo[]|null
     */
    public function getFareInfo()
    {
        return $this->FareInfo;
    }
    /**
     * Set FareInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FareInfo[] $fareInfo
     * @return \StructType\FareInfoType
     */
    public function setFareInfo(array $fareInfo = array())
    {
        foreach ($fareInfo as $fareInfoTypeFareInfoItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeFareInfoItem instanceof \StructType\FareInfo) {
                throw new \InvalidArgumentException(sprintf('The FareInfo property can only contain items of \StructType\FareInfo, "%s" given', is_object($fareInfoTypeFareInfoItem) ? get_class($fareInfoTypeFareInfoItem) : gettype($fareInfoTypeFareInfoItem)), __LINE__);
            }
        }
        $this->FareInfo = $fareInfo;
        return $this;
    }
    /**
     * Add item to FareInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FareInfo $item
     * @return \StructType\FareInfoType
     */
    public function addToFareInfo(\StructType\FareInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareInfo) {
            throw new \InvalidArgumentException(sprintf('The FareInfo property can only contain items of \StructType\FareInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareInfo[] = $item;
        return $this;
    }
    /**
     * Get FareRuleReference value
     * @return string|null
     */
    public function getFareRuleReference()
    {
        return $this->FareRuleReference;
    }
    /**
     * Set FareRuleReference value
     * @param string $fareRuleReference
     * @return \StructType\FareInfoType
     */
    public function setFareRuleReference($fareRuleReference = null)
    {
        // validation for constraint: string
        if (!is_null($fareRuleReference) && !is_string($fareRuleReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareRuleReference)), __LINE__);
        }
        $this->FareRuleReference = $fareRuleReference;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\FareInfoType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get TariffNumber value
     * @return string|null
     */
    public function getTariffNumber()
    {
        return $this->TariffNumber;
    }
    /**
     * Set TariffNumber value
     * @param string $tariffNumber
     * @return \StructType\FareInfoType
     */
    public function setTariffNumber($tariffNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tariffNumber) && !is_string($tariffNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariffNumber)), __LINE__);
        }
        $this->TariffNumber = $tariffNumber;
        return $this;
    }
    /**
     * Get RuleNumber value
     * @return string|null
     */
    public function getRuleNumber()
    {
        return $this->RuleNumber;
    }
    /**
     * Set RuleNumber value
     * @param string $ruleNumber
     * @return \StructType\FareInfoType
     */
    public function setRuleNumber($ruleNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ruleNumber) && !is_string($ruleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ruleNumber)), __LINE__);
        }
        $this->RuleNumber = $ruleNumber;
        return $this;
    }
    /**
     * Get adultFare value
     * @return string|null
     */
    public function getAdultFare()
    {
        return $this->adultFare;
    }
    /**
     * Set adultFare value
     * @param string $adultFare
     * @return \StructType\FareInfoType
     */
    public function setAdultFare($adultFare = null)
    {
        // validation for constraint: string
        if (!is_null($adultFare) && !is_string($adultFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adultFare)), __LINE__);
        }
        $this->adultFare = $adultFare;
        return $this;
    }
    /**
     * Get childFare value
     * @return string|null
     */
    public function getChildFare()
    {
        return $this->childFare;
    }
    /**
     * Set childFare value
     * @param string $childFare
     * @return \StructType\FareInfoType
     */
    public function setChildFare($childFare = null)
    {
        // validation for constraint: string
        if (!is_null($childFare) && !is_string($childFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($childFare)), __LINE__);
        }
        $this->childFare = $childFare;
        return $this;
    }
    /**
     * Get infantFare value
     * @return string|null
     */
    public function getInfantFare()
    {
        return $this->infantFare;
    }
    /**
     * Set infantFare value
     * @param string $infantFare
     * @return \StructType\FareInfoType
     */
    public function setInfantFare($infantFare = null)
    {
        // validation for constraint: string
        if (!is_null($infantFare) && !is_string($infantFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infantFare)), __LINE__);
        }
        $this->infantFare = $infantFare;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FareInfoType
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get SegmentCode value
     * @return string|null
     */
    public function getSegmentCode()
    {
        return $this->SegmentCode;
    }
    /**
     * Set SegmentCode value
     * @param string $segmentCode
     * @return \StructType\FareInfoType
     */
    public function setSegmentCode($segmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentCode) && !is_string($segmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentCode)), __LINE__);
        }
        $this->SegmentCode = $segmentCode;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\FareInfoType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get FareRuleInfo value
     * @return string|null
     */
    public function getFareRuleInfo()
    {
        return $this->FareRuleInfo;
    }
    /**
     * Set FareRuleInfo value
     * @param string $fareRuleInfo
     * @return \StructType\FareInfoType
     */
    public function setFareRuleInfo($fareRuleInfo = null)
    {
        // validation for constraint: string
        if (!is_null($fareRuleInfo) && !is_string($fareRuleInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareRuleInfo)), __LINE__);
        }
        $this->FareRuleInfo = $fareRuleInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
