<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Provides information on a specific documents
 * @subpackage Structs
 */
class DocumentType extends AbstractStructBase
{
    /**
     * The DocHolderName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the document holder in unformatted text (Mr. Sam Jones).
     * - minOccurs: 0
     * @var mixed
     */
    public $DocHolderName;
    /**
     * The DocHolderFormattedName
     * Meta informations extracted from the WSDL
     * - documentation: The name of document holder in formatted text.
     * - minOccurs: 0
     * @var mixed
     */
    public $DocHolderFormattedName;
    /**
     * The DocLimitations
     * Meta informations extracted from the WSDL
     * - documentation: Used to indicate any limitations on the document (e.g. as a person may only be allowed to spend a max of 30 days in country on a visitor's visa).
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $DocLimitations;
    /**
     * The AdditionalPersonNames
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalPersonNames
     */
    public $AdditionalPersonNames;
    /**
     * The DocIssueAuthority
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the group or association that granted the document.
     * - use: optional
     * @var string
     */
    public $DocIssueAuthority;
    /**
     * The DocIssueLocation
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the location where the document was issued.
     * - use: optional
     * @var string
     */
    public $DocIssueLocation;
    /**
     * The DocID
     * Meta informations extracted from the WSDL
     * - documentation: Unique number assigned by authorities to document.
     * - use: optional
     * @var string
     */
    public $DocID;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the type of document (e.g. Passport, Military ID, Drivers License, national ID, Vaccination Certificate). Refer to OTA Code List Document Type (DOC).
     * - use: optional
     * @var string
     */
    public $DocType;
    /**
     * The DocIssueStateProv
     * Meta informations extracted from the WSDL
     * - documentation: State or Province where the document was issued.
     * - use: optional
     * @var string
     */
    public $DocIssueStateProv;
    /**
     * The DocIssueCountry
     * Meta informations extracted from the WSDL
     * - documentation: Country where the document was issued.
     * - use: optional
     * @var string
     */
    public $DocIssueCountry;
    /**
     * The BirthCountry
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the birth country of the document holder.
     * - use: optional
     * @var string
     */
    public $BirthCountry;
    /**
     * The DocHolderNationality
     * Meta informations extracted from the WSDL
     * - documentation: The country code of the nationality of the document holder.
     * @var string
     */
    public $DocHolderNationality;
    /**
     * Constructor method for DocumentType
     * @uses DocumentType::setDocHolderName()
     * @uses DocumentType::setDocHolderFormattedName()
     * @uses DocumentType::setDocLimitations()
     * @uses DocumentType::setAdditionalPersonNames()
     * @uses DocumentType::setDocIssueAuthority()
     * @uses DocumentType::setDocIssueLocation()
     * @uses DocumentType::setDocID()
     * @uses DocumentType::setDocType()
     * @uses DocumentType::setDocIssueStateProv()
     * @uses DocumentType::setDocIssueCountry()
     * @uses DocumentType::setBirthCountry()
     * @uses DocumentType::setDocHolderNationality()
     * @param mixed $docHolderName
     * @param mixed $docHolderFormattedName
     * @param mixed[] $docLimitations
     * @param \StructType\AdditionalPersonNames $additionalPersonNames
     * @param string $docIssueAuthority
     * @param string $docIssueLocation
     * @param string $docID
     * @param string $docType
     * @param string $docIssueStateProv
     * @param string $docIssueCountry
     * @param string $birthCountry
     * @param string $docHolderNationality
     */
    public function __construct($docHolderName = null, $docHolderFormattedName = null, array $docLimitations = array(), \StructType\AdditionalPersonNames $additionalPersonNames = null, $docIssueAuthority = null, $docIssueLocation = null, $docID = null, $docType = null, $docIssueStateProv = null, $docIssueCountry = null, $birthCountry = null, $docHolderNationality = null)
    {
        $this
            ->setDocHolderName($docHolderName)
            ->setDocHolderFormattedName($docHolderFormattedName)
            ->setDocLimitations($docLimitations)
            ->setAdditionalPersonNames($additionalPersonNames)
            ->setDocIssueAuthority($docIssueAuthority)
            ->setDocIssueLocation($docIssueLocation)
            ->setDocID($docID)
            ->setDocType($docType)
            ->setDocIssueStateProv($docIssueStateProv)
            ->setDocIssueCountry($docIssueCountry)
            ->setBirthCountry($birthCountry)
            ->setDocHolderNationality($docHolderNationality);
    }
    /**
     * Get DocHolderName value
     * @return mixed|null
     */
    public function getDocHolderName()
    {
        return $this->DocHolderName;
    }
    /**
     * Set DocHolderName value
     * @param mixed $docHolderName
     * @return \StructType\DocumentType
     */
    public function setDocHolderName($docHolderName = null)
    {
        $this->DocHolderName = $docHolderName;
        return $this;
    }
    /**
     * Get DocHolderFormattedName value
     * @return mixed|null
     */
    public function getDocHolderFormattedName()
    {
        return $this->DocHolderFormattedName;
    }
    /**
     * Set DocHolderFormattedName value
     * @param mixed $docHolderFormattedName
     * @return \StructType\DocumentType
     */
    public function setDocHolderFormattedName($docHolderFormattedName = null)
    {
        $this->DocHolderFormattedName = $docHolderFormattedName;
        return $this;
    }
    /**
     * Get DocLimitations value
     * @return mixed[]|null
     */
    public function getDocLimitations()
    {
        return $this->DocLimitations;
    }
    /**
     * Set DocLimitations value
     * @throws \InvalidArgumentException
     * @param mixed[] $docLimitations
     * @return \StructType\DocumentType
     */
    public function setDocLimitations(array $docLimitations = array())
    {
        foreach ($docLimitations as $documentTypeDocLimitationsItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The DocLimitations property can only contain items of anyType, "%s" given', is_object($documentTypeDocLimitationsItem) ? get_class($documentTypeDocLimitationsItem) : gettype($documentTypeDocLimitationsItem)), __LINE__);
            }
        }
        $this->DocLimitations = $docLimitations;
        return $this;
    }
    /**
     * Add item to DocLimitations value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\DocumentType
     */
    public function addToDocLimitations($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The DocLimitations property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DocLimitations[] = $item;
        return $this;
    }
    /**
     * Get AdditionalPersonNames value
     * @return \StructType\AdditionalPersonNames|null
     */
    public function getAdditionalPersonNames()
    {
        return $this->AdditionalPersonNames;
    }
    /**
     * Set AdditionalPersonNames value
     * @param \StructType\AdditionalPersonNames $additionalPersonNames
     * @return \StructType\DocumentType
     */
    public function setAdditionalPersonNames(\StructType\AdditionalPersonNames $additionalPersonNames = null)
    {
        $this->AdditionalPersonNames = $additionalPersonNames;
        return $this;
    }
    /**
     * Get DocIssueAuthority value
     * @return string|null
     */
    public function getDocIssueAuthority()
    {
        return $this->DocIssueAuthority;
    }
    /**
     * Set DocIssueAuthority value
     * @param string $docIssueAuthority
     * @return \StructType\DocumentType
     */
    public function setDocIssueAuthority($docIssueAuthority = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueAuthority) && !is_string($docIssueAuthority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueAuthority)), __LINE__);
        }
        $this->DocIssueAuthority = $docIssueAuthority;
        return $this;
    }
    /**
     * Get DocIssueLocation value
     * @return string|null
     */
    public function getDocIssueLocation()
    {
        return $this->DocIssueLocation;
    }
    /**
     * Set DocIssueLocation value
     * @param string $docIssueLocation
     * @return \StructType\DocumentType
     */
    public function setDocIssueLocation($docIssueLocation = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueLocation) && !is_string($docIssueLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueLocation)), __LINE__);
        }
        $this->DocIssueLocation = $docIssueLocation;
        return $this;
    }
    /**
     * Get DocID value
     * @return string|null
     */
    public function getDocID()
    {
        return $this->DocID;
    }
    /**
     * Set DocID value
     * @param string $docID
     * @return \StructType\DocumentType
     */
    public function setDocID($docID = null)
    {
        // validation for constraint: string
        if (!is_null($docID) && !is_string($docID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docID)), __LINE__);
        }
        $this->DocID = $docID;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\DocumentType
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get DocIssueStateProv value
     * @return string|null
     */
    public function getDocIssueStateProv()
    {
        return $this->DocIssueStateProv;
    }
    /**
     * Set DocIssueStateProv value
     * @param string $docIssueStateProv
     * @return \StructType\DocumentType
     */
    public function setDocIssueStateProv($docIssueStateProv = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueStateProv) && !is_string($docIssueStateProv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueStateProv)), __LINE__);
        }
        $this->DocIssueStateProv = $docIssueStateProv;
        return $this;
    }
    /**
     * Get DocIssueCountry value
     * @return string|null
     */
    public function getDocIssueCountry()
    {
        return $this->DocIssueCountry;
    }
    /**
     * Set DocIssueCountry value
     * @param string $docIssueCountry
     * @return \StructType\DocumentType
     */
    public function setDocIssueCountry($docIssueCountry = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueCountry) && !is_string($docIssueCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueCountry)), __LINE__);
        }
        $this->DocIssueCountry = $docIssueCountry;
        return $this;
    }
    /**
     * Get BirthCountry value
     * @return string|null
     */
    public function getBirthCountry()
    {
        return $this->BirthCountry;
    }
    /**
     * Set BirthCountry value
     * @param string $birthCountry
     * @return \StructType\DocumentType
     */
    public function setBirthCountry($birthCountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthCountry) && !is_string($birthCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthCountry)), __LINE__);
        }
        $this->BirthCountry = $birthCountry;
        return $this;
    }
    /**
     * Get DocHolderNationality value
     * @return string|null
     */
    public function getDocHolderNationality()
    {
        return $this->DocHolderNationality;
    }
    /**
     * Set DocHolderNationality value
     * @param string $docHolderNationality
     * @return \StructType\DocumentType
     */
    public function setDocHolderNationality($docHolderNationality = null)
    {
        // validation for constraint: string
        if (!is_null($docHolderNationality) && !is_string($docHolderNationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docHolderNationality)), __LINE__);
        }
        $this->DocHolderNationality = $docHolderNationality;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
