<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistribPrefType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type of ticket distribution to be used with this collection of preferences. | Used for Character Strings, length 0 to 64
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class DistribPrefType extends AbstractStructBase
{
    /**
     * The DistribType
     * Meta informations extracted from the WSDL
     * - documentation: Ticket distribution method (e.g. Fax, Email, Courier, Mail, Airport_Pickup, City_Office, Hotel_Desk, WillCall). Refer to OTA Code List Distribution Type (DTB).
     * @var string
     */
    public $DistribType;
    /**
     * Constructor method for DistribPrefType
     * @uses DistribPrefType::setDistribType()
     * @param string $distribType
     */
    public function __construct($distribType = null)
    {
        $this
            ->setDistribType($distribType);
    }
    /**
     * Get DistribType value
     * @return string|null
     */
    public function getDistribType()
    {
        return $this->DistribType;
    }
    /**
     * Set DistribType value
     * @param string $distribType
     * @return \StructType\DistribPrefType
     */
    public function setDistribType($distribType = null)
    {
        // validation for constraint: string
        if (!is_null($distribType) && !is_string($distribType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distribType)), __LINE__);
        }
        $this->DistribType = $distribType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistribPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
