<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Destinations StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for any number of destinations that the traveler(s) will reach during their journey.
 * @subpackage Structs
 */
class Destinations extends AbstractStructBase
{
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\Destination[]
     */
    public $Destination;
    /**
     * Constructor method for Destinations
     * @uses Destinations::setDestination()
     * @param \StructType\Destination[] $destination
     */
    public function __construct(array $destination = array())
    {
        $this
            ->setDestination($destination);
    }
    /**
     * Get Destination value
     * @return \StructType\Destination[]|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @throws \InvalidArgumentException
     * @param \StructType\Destination[] $destination
     * @return \StructType\Destinations
     */
    public function setDestination(array $destination = array())
    {
        foreach ($destination as $destinationsDestinationItem) {
            // validation for constraint: itemType
            if (!$destinationsDestinationItem instanceof \StructType\Destination) {
                throw new \InvalidArgumentException(sprintf('The Destination property can only contain items of \StructType\Destination, "%s" given', is_object($destinationsDestinationItem) ? get_class($destinationsDestinationItem) : gettype($destinationsDestinationItem)), __LINE__);
            }
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Add item to Destination value
     * @throws \InvalidArgumentException
     * @param \StructType\Destination $item
     * @return \StructType\Destinations
     */
    public function addToDestination(\StructType\Destination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Destination) {
            throw new \InvalidArgumentException(sprintf('The Destination property can only contain items of \StructType\Destination, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Destination[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Destinations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
