<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepartureAirport StructType
 * Meta informations extracted from the WSDL
 * - documentation: Departure airport for flight leg. | Departure point of flight segment.
 * @subpackage Structs
 */
class DepartureAirport extends AbstractStructBase
{
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Any special comments about the departure airport.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FreeTextType[]
     */
    public $Comment;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: Location code used to identify a specific airport. | Code used to identify a location.
     * @var string
     */
    public $LocationCode;
    /**
     * The CodeContext
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the context of the identifying code, such as IATA, ARC, or internal code, etc. | Identifies the context of the identifying code (e.g., IATA, ARC, or internal code).
     * @var string
     */
    public $CodeContext;
    /**
     * The Terminal
     * Meta informations extracted from the WSDL
     * - documentation: Arrival or departure terminal (e.g., Concourse A)
     * @var string
     */
    public $Terminal;
    /**
     * The Gate
     * Meta informations extracted from the WSDL
     * - documentation: Arrival or departure gate (e.g., B12)
     * @var string
     */
    public $Gate;
    /**
     * Constructor method for DepartureAirport
     * @uses DepartureAirport::setComment()
     * @uses DepartureAirport::setLocationCode()
     * @uses DepartureAirport::setCodeContext()
     * @uses DepartureAirport::setTerminal()
     * @uses DepartureAirport::setGate()
     * @param \StructType\FreeTextType[] $comment
     * @param string $locationCode
     * @param string $codeContext
     * @param string $terminal
     * @param string $gate
     */
    public function __construct(array $comment = array(), $locationCode = null, $codeContext = null, $terminal = null, $gate = null)
    {
        $this
            ->setComment($comment)
            ->setLocationCode($locationCode)
            ->setCodeContext($codeContext)
            ->setTerminal($terminal)
            ->setGate($gate);
    }
    /**
     * Get Comment value
     * @return \StructType\FreeTextType[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType[] $comment
     * @return \StructType\DepartureAirport
     */
    public function setComment(array $comment = array())
    {
        foreach ($comment as $departureAirportCommentItem) {
            // validation for constraint: itemType
            if (!$departureAirportCommentItem instanceof \StructType\FreeTextType) {
                throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \StructType\FreeTextType, "%s" given', is_object($departureAirportCommentItem) ? get_class($departureAirportCommentItem) : gettype($departureAirportCommentItem)), __LINE__);
            }
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType $item
     * @return \StructType\DepartureAirport
     */
    public function addToComment(\StructType\FreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FreeTextType) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \StructType\FreeTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \StructType\DepartureAirport
     */
    public function setLocationCode($locationCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCode) && !is_string($locationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationCode)), __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\DepartureAirport
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \StructType\DepartureAirport
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: string
        if (!is_null($terminal) && !is_string($terminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminal)), __LINE__);
        }
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Get Gate value
     * @return string|null
     */
    public function getGate()
    {
        return $this->Gate;
    }
    /**
     * Set Gate value
     * @param string $gate
     * @return \StructType\DepartureAirport
     */
    public function setGate($gate = null)
    {
        // validation for constraint: string
        if (!is_null($gate) && !is_string($gate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gate)), __LINE__);
        }
        $this->Gate = $gate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DepartureAirport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
