<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoveredTrips StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for any information about the trip(s) for which the traveler(s) are requesting coverage.
 * @subpackage Structs
 */
class CoveredTrips extends AbstractStructBase
{
    /**
     * The CoveredTrip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\CoveredTrip[]
     */
    public $CoveredTrip;
    /**
     * Constructor method for CoveredTrips
     * @uses CoveredTrips::setCoveredTrip()
     * @param \StructType\CoveredTrip[] $coveredTrip
     */
    public function __construct(array $coveredTrip = array())
    {
        $this
            ->setCoveredTrip($coveredTrip);
    }
    /**
     * Get CoveredTrip value
     * @return \StructType\CoveredTrip[]|null
     */
    public function getCoveredTrip()
    {
        return $this->CoveredTrip;
    }
    /**
     * Set CoveredTrip value
     * @throws \InvalidArgumentException
     * @param \StructType\CoveredTrip[] $coveredTrip
     * @return \StructType\CoveredTrips
     */
    public function setCoveredTrip(array $coveredTrip = array())
    {
        foreach ($coveredTrip as $coveredTripsCoveredTripItem) {
            // validation for constraint: itemType
            if (!$coveredTripsCoveredTripItem instanceof \StructType\CoveredTrip) {
                throw new \InvalidArgumentException(sprintf('The CoveredTrip property can only contain items of \StructType\CoveredTrip, "%s" given', is_object($coveredTripsCoveredTripItem) ? get_class($coveredTripsCoveredTripItem) : gettype($coveredTripsCoveredTripItem)), __LINE__);
            }
        }
        $this->CoveredTrip = $coveredTrip;
        return $this;
    }
    /**
     * Add item to CoveredTrip value
     * @throws \InvalidArgumentException
     * @param \StructType\CoveredTrip $item
     * @return \StructType\CoveredTrips
     */
    public function addToCoveredTrip(\StructType\CoveredTrip $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CoveredTrip) {
            throw new \InvalidArgumentException(sprintf('The CoveredTrip property can only contain items of \StructType\CoveredTrip, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CoveredTrip[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoveredTrips
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
