<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoveredTrip StructType
 * Meta informations extracted from the WSDL
 * - documentation: Information about a single trip for which the traveler(s) are requesting coverage.
 * @subpackage Structs
 */
class CoveredTrip extends TripFeaturesType
{
    /**
     * The DepositDate
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DepositDate;
    /**
     * The FinalPayDate
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FinalPayDate;
    /**
     * Constructor method for CoveredTrip
     * @uses CoveredTrip::setDepositDate()
     * @uses CoveredTrip::setFinalPayDate()
     * @param string $depositDate
     * @param string $finalPayDate
     */
    public function __construct($depositDate = null, $finalPayDate = null)
    {
        $this
            ->setDepositDate($depositDate)
            ->setFinalPayDate($finalPayDate);
    }
    /**
     * Get DepositDate value
     * @return string|null
     */
    public function getDepositDate()
    {
        return $this->DepositDate;
    }
    /**
     * Set DepositDate value
     * @param string $depositDate
     * @return \StructType\CoveredTrip
     */
    public function setDepositDate($depositDate = null)
    {
        // validation for constraint: string
        if (!is_null($depositDate) && !is_string($depositDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depositDate)), __LINE__);
        }
        $this->DepositDate = $depositDate;
        return $this;
    }
    /**
     * Get FinalPayDate value
     * @return string|null
     */
    public function getFinalPayDate()
    {
        return $this->FinalPayDate;
    }
    /**
     * Set FinalPayDate value
     * @param string $finalPayDate
     * @return \StructType\CoveredTrip
     */
    public function setFinalPayDate($finalPayDate = null)
    {
        // validation for constraint: string
        if (!is_null($finalPayDate) && !is_string($finalPayDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finalPayDate)), __LINE__);
        }
        $this->FinalPayDate = $finalPayDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoveredTrip
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
