<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoveredTravelerType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains identifying information as well as coverage requirements and journey information for each individual requesting coverage by the insurance plan.
 * @subpackage Structs
 */
class CoveredTravelerType extends AbstractStructBase
{
    /**
     * The CoveredPerson
     * @var \StructType\CoveredPerson
     */
    public $CoveredPerson;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - documentation: Defines an electronic mail address of the traveler.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Email;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Defines a physical address for the traveler.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Address;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Telephone;
    /**
     * The CitizenCountryName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CitizenCountryName
     */
    public $CitizenCountryName;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - documentation: Contains information about documents used for travel, such as passports, driver's licenses or social security numbers.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Document;
    /**
     * The EmergencyContact
     * Meta informations extracted from the WSDL
     * - documentation: Defines an emergency contact person for traveler.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $EmergencyContact;
    /**
     * The Beneficiary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Beneficiary[]
     */
    public $Beneficiary;
    /**
     * The IndCoverageReqs
     * Meta informations extracted from the WSDL
     * - documentation: Contains certain traveler-specific information required for quoting or booking an insurance plan.
     * - minOccurs: 0
     * @var mixed
     */
    public $IndCoverageReqs;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for CoveredTravelerType
     * @uses CoveredTravelerType::setCoveredPerson()
     * @uses CoveredTravelerType::setEmail()
     * @uses CoveredTravelerType::setAddress()
     * @uses CoveredTravelerType::setTelephone()
     * @uses CoveredTravelerType::setCitizenCountryName()
     * @uses CoveredTravelerType::setDocument()
     * @uses CoveredTravelerType::setEmergencyContact()
     * @uses CoveredTravelerType::setBeneficiary()
     * @uses CoveredTravelerType::setIndCoverageReqs()
     * @uses CoveredTravelerType::setRPH()
     * @param \StructType\CoveredPerson $coveredPerson
     * @param mixed[] $email
     * @param mixed[] $address
     * @param mixed[] $telephone
     * @param \StructType\CitizenCountryName $citizenCountryName
     * @param mixed[] $document
     * @param mixed[] $emergencyContact
     * @param \StructType\Beneficiary[] $beneficiary
     * @param mixed $indCoverageReqs
     * @param string $rPH
     */
    public function __construct(\StructType\CoveredPerson $coveredPerson = null, array $email = array(), array $address = array(), array $telephone = array(), \StructType\CitizenCountryName $citizenCountryName = null, array $document = array(), array $emergencyContact = array(), array $beneficiary = array(), $indCoverageReqs = null, $rPH = null)
    {
        $this
            ->setCoveredPerson($coveredPerson)
            ->setEmail($email)
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setCitizenCountryName($citizenCountryName)
            ->setDocument($document)
            ->setEmergencyContact($emergencyContact)
            ->setBeneficiary($beneficiary)
            ->setIndCoverageReqs($indCoverageReqs)
            ->setRPH($rPH);
    }
    /**
     * Get CoveredPerson value
     * @return \StructType\CoveredPerson|null
     */
    public function getCoveredPerson()
    {
        return $this->CoveredPerson;
    }
    /**
     * Set CoveredPerson value
     * @param \StructType\CoveredPerson $coveredPerson
     * @return \StructType\CoveredTravelerType
     */
    public function setCoveredPerson(\StructType\CoveredPerson $coveredPerson = null)
    {
        $this->CoveredPerson = $coveredPerson;
        return $this;
    }
    /**
     * Get Email value
     * @return mixed[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param mixed[] $email
     * @return \StructType\CoveredTravelerType
     */
    public function setEmail(array $email = array())
    {
        foreach ($email as $coveredTravelerTypeEmailItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The Email property can only contain items of anyType, "%s" given', is_object($coveredTravelerTypeEmailItem) ? get_class($coveredTravelerTypeEmailItem) : gettype($coveredTravelerTypeEmailItem)), __LINE__);
            }
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CoveredTravelerType
     */
    public function addToEmail($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return mixed[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param mixed[] $address
     * @return \StructType\CoveredTravelerType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $coveredTravelerTypeAddressItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The Address property can only contain items of anyType, "%s" given', is_object($coveredTravelerTypeAddressItem) ? get_class($coveredTravelerTypeAddressItem) : gettype($coveredTravelerTypeAddressItem)), __LINE__);
            }
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CoveredTravelerType
     */
    public function addToAddress($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get Telephone value
     * @return mixed[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param mixed[] $telephone
     * @return \StructType\CoveredTravelerType
     */
    public function setTelephone(array $telephone = array())
    {
        foreach ($telephone as $coveredTravelerTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of anyType, "%s" given', is_object($coveredTravelerTypeTelephoneItem) ? get_class($coveredTravelerTypeTelephoneItem) : gettype($coveredTravelerTypeTelephoneItem)), __LINE__);
            }
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CoveredTravelerType
     */
    public function addToTelephone($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \StructType\CitizenCountryName|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * Set CitizenCountryName value
     * @param \StructType\CitizenCountryName $citizenCountryName
     * @return \StructType\CoveredTravelerType
     */
    public function setCitizenCountryName(\StructType\CitizenCountryName $citizenCountryName = null)
    {
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Get Document value
     * @return mixed[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param mixed[] $document
     * @return \StructType\CoveredTravelerType
     */
    public function setDocument(array $document = array())
    {
        foreach ($document as $coveredTravelerTypeDocumentItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The Document property can only contain items of anyType, "%s" given', is_object($coveredTravelerTypeDocumentItem) ? get_class($coveredTravelerTypeDocumentItem) : gettype($coveredTravelerTypeDocumentItem)), __LINE__);
            }
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CoveredTravelerType
     */
    public function addToDocument($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get EmergencyContact value
     * @return mixed[]|null
     */
    public function getEmergencyContact()
    {
        return $this->EmergencyContact;
    }
    /**
     * Set EmergencyContact value
     * @throws \InvalidArgumentException
     * @param mixed[] $emergencyContact
     * @return \StructType\CoveredTravelerType
     */
    public function setEmergencyContact(array $emergencyContact = array())
    {
        foreach ($emergencyContact as $coveredTravelerTypeEmergencyContactItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The EmergencyContact property can only contain items of anyType, "%s" given', is_object($coveredTravelerTypeEmergencyContactItem) ? get_class($coveredTravelerTypeEmergencyContactItem) : gettype($coveredTravelerTypeEmergencyContactItem)), __LINE__);
            }
        }
        $this->EmergencyContact = $emergencyContact;
        return $this;
    }
    /**
     * Add item to EmergencyContact value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CoveredTravelerType
     */
    public function addToEmergencyContact($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The EmergencyContact property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmergencyContact[] = $item;
        return $this;
    }
    /**
     * Get Beneficiary value
     * @return \StructType\Beneficiary[]|null
     */
    public function getBeneficiary()
    {
        return $this->Beneficiary;
    }
    /**
     * Set Beneficiary value
     * @throws \InvalidArgumentException
     * @param \StructType\Beneficiary[] $beneficiary
     * @return \StructType\CoveredTravelerType
     */
    public function setBeneficiary(array $beneficiary = array())
    {
        foreach ($beneficiary as $coveredTravelerTypeBeneficiaryItem) {
            // validation for constraint: itemType
            if (!$coveredTravelerTypeBeneficiaryItem instanceof \StructType\Beneficiary) {
                throw new \InvalidArgumentException(sprintf('The Beneficiary property can only contain items of \StructType\Beneficiary, "%s" given', is_object($coveredTravelerTypeBeneficiaryItem) ? get_class($coveredTravelerTypeBeneficiaryItem) : gettype($coveredTravelerTypeBeneficiaryItem)), __LINE__);
            }
        }
        $this->Beneficiary = $beneficiary;
        return $this;
    }
    /**
     * Add item to Beneficiary value
     * @throws \InvalidArgumentException
     * @param \StructType\Beneficiary $item
     * @return \StructType\CoveredTravelerType
     */
    public function addToBeneficiary(\StructType\Beneficiary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Beneficiary) {
            throw new \InvalidArgumentException(sprintf('The Beneficiary property can only contain items of \StructType\Beneficiary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Beneficiary[] = $item;
        return $this;
    }
    /**
     * Get IndCoverageReqs value
     * @return mixed|null
     */
    public function getIndCoverageReqs()
    {
        return $this->IndCoverageReqs;
    }
    /**
     * Set IndCoverageReqs value
     * @param mixed $indCoverageReqs
     * @return \StructType\CoveredTravelerType
     */
    public function setIndCoverageReqs($indCoverageReqs = null)
    {
        $this->IndCoverageReqs = $indCoverageReqs;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\CoveredTravelerType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoveredTravelerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
