<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoveredPerson StructType
 * Meta informations extracted from the WSDL
 * - documentation: Identifies an individual requesting to be covered by the insurance policy.
 * @subpackage Structs
 */
class CoveredPerson extends PersonNameType
{
    /**
     * The Relation
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Relation;
    /**
     * The Age
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Age;
    /**
     * Constructor method for CoveredPerson
     * @uses CoveredPerson::setRelation()
     * @uses CoveredPerson::setAge()
     * @param string $relation
     * @param int $age
     */
    public function __construct($relation = null, $age = null)
    {
        $this
            ->setRelation($relation)
            ->setAge($age);
    }
    /**
     * Get Relation value
     * @return string
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * Set Relation value
     * @param string $relation
     * @return \StructType\CoveredPerson
     */
    public function setRelation($relation = null)
    {
        // validation for constraint: string
        if (!is_null($relation) && !is_string($relation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relation)), __LINE__);
        }
        $this->Relation = $relation;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\CoveredPerson
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !is_numeric($age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoveredPerson
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
