<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BundledService StructType
 * @subpackage Structs
 */
class BundledService extends AbstractStructBase
{
    /**
     * The bunldedServiceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $bunldedServiceId;
    /**
     * The bundledServiceName
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $bundledServiceName;
    /**
     * The perPaxBundledFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $perPaxBundledFee;
    /**
     * The includedServies
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $includedServies;
    /**
     * The bookingClasses
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $bookingClasses;
    /**
     * The segmentBookingClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $segmentBookingClass;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * Constructor method for BundledService
     * @uses BundledService::setBunldedServiceId()
     * @uses BundledService::setBundledServiceName()
     * @uses BundledService::setPerPaxBundledFee()
     * @uses BundledService::setIncludedServies()
     * @uses BundledService::setBookingClasses()
     * @uses BundledService::setSegmentBookingClass()
     * @uses BundledService::setDescription()
     * @param int $bunldedServiceId
     * @param string $bundledServiceName
     * @param float $perPaxBundledFee
     * @param string[] $includedServies
     * @param string[] $bookingClasses
     * @param mixed[] $segmentBookingClass
     * @param string $description
     */
    public function __construct($bunldedServiceId = null, $bundledServiceName = null, $perPaxBundledFee = null, array $includedServies = array(), array $bookingClasses = array(), array $segmentBookingClass = array(), $description = null)
    {
        $this
            ->setBunldedServiceId($bunldedServiceId)
            ->setBundledServiceName($bundledServiceName)
            ->setPerPaxBundledFee($perPaxBundledFee)
            ->setIncludedServies($includedServies)
            ->setBookingClasses($bookingClasses)
            ->setSegmentBookingClass($segmentBookingClass)
            ->setDescription($description);
    }
    /**
     * Get bunldedServiceId value
     * @return int
     */
    public function getBunldedServiceId()
    {
        return $this->bunldedServiceId;
    }
    /**
     * Set bunldedServiceId value
     * @param int $bunldedServiceId
     * @return \StructType\BundledService
     */
    public function setBunldedServiceId($bunldedServiceId = null)
    {
        // validation for constraint: int
        if (!is_null($bunldedServiceId) && !is_numeric($bunldedServiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bunldedServiceId)), __LINE__);
        }
        $this->bunldedServiceId = $bunldedServiceId;
        return $this;
    }
    /**
     * Get bundledServiceName value
     * @return string
     */
    public function getBundledServiceName()
    {
        return $this->bundledServiceName;
    }
    /**
     * Set bundledServiceName value
     * @param string $bundledServiceName
     * @return \StructType\BundledService
     */
    public function setBundledServiceName($bundledServiceName = null)
    {
        // validation for constraint: string
        if (!is_null($bundledServiceName) && !is_string($bundledServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bundledServiceName)), __LINE__);
        }
        $this->bundledServiceName = $bundledServiceName;
        return $this;
    }
    /**
     * Get perPaxBundledFee value
     * @return float
     */
    public function getPerPaxBundledFee()
    {
        return $this->perPaxBundledFee;
    }
    /**
     * Set perPaxBundledFee value
     * @param float $perPaxBundledFee
     * @return \StructType\BundledService
     */
    public function setPerPaxBundledFee($perPaxBundledFee = null)
    {
        $this->perPaxBundledFee = $perPaxBundledFee;
        return $this;
    }
    /**
     * Get includedServies value
     * @return string[]
     */
    public function getIncludedServies()
    {
        return $this->includedServies;
    }
    /**
     * Set includedServies value
     * @throws \InvalidArgumentException
     * @param string[] $includedServies
     * @return \StructType\BundledService
     */
    public function setIncludedServies(array $includedServies = array())
    {
        foreach ($includedServies as $bundledServiceIncludedServiesItem) {
            // validation for constraint: itemType
            if (!is_string($bundledServiceIncludedServiesItem)) {
                throw new \InvalidArgumentException(sprintf('The includedServies property can only contain items of string, "%s" given', is_object($bundledServiceIncludedServiesItem) ? get_class($bundledServiceIncludedServiesItem) : gettype($bundledServiceIncludedServiesItem)), __LINE__);
            }
        }
        $this->includedServies = $includedServies;
        return $this;
    }
    /**
     * Add item to includedServies value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BundledService
     */
    public function addToIncludedServies($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The includedServies property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->includedServies[] = $item;
        return $this;
    }
    /**
     * Get bookingClasses value
     * @return string[]|null
     */
    public function getBookingClasses()
    {
        return $this->bookingClasses;
    }
    /**
     * Set bookingClasses value
     * @throws \InvalidArgumentException
     * @param string[] $bookingClasses
     * @return \StructType\BundledService
     */
    public function setBookingClasses(array $bookingClasses = array())
    {
        foreach ($bookingClasses as $bundledServiceBookingClassesItem) {
            // validation for constraint: itemType
            if (!is_string($bundledServiceBookingClassesItem)) {
                throw new \InvalidArgumentException(sprintf('The bookingClasses property can only contain items of string, "%s" given', is_object($bundledServiceBookingClassesItem) ? get_class($bundledServiceBookingClassesItem) : gettype($bundledServiceBookingClassesItem)), __LINE__);
            }
        }
        $this->bookingClasses = $bookingClasses;
        return $this;
    }
    /**
     * Add item to bookingClasses value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BundledService
     */
    public function addToBookingClasses($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The bookingClasses property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->bookingClasses[] = $item;
        return $this;
    }
    /**
     * Get segmentBookingClass value
     * @return mixed[]|null
     */
    public function getSegmentBookingClass()
    {
        return $this->segmentBookingClass;
    }
    /**
     * Set segmentBookingClass value
     * @throws \InvalidArgumentException
     * @param mixed[] $segmentBookingClass
     * @return \StructType\BundledService
     */
    public function setSegmentBookingClass(array $segmentBookingClass = array())
    {
        foreach ($segmentBookingClass as $bundledServiceSegmentBookingClassItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The segmentBookingClass property can only contain items of anyType, "%s" given', is_object($bundledServiceSegmentBookingClassItem) ? get_class($bundledServiceSegmentBookingClassItem) : gettype($bundledServiceSegmentBookingClassItem)), __LINE__);
            }
        }
        $this->segmentBookingClass = $segmentBookingClass;
        return $this;
    }
    /**
     * Add item to segmentBookingClass value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\BundledService
     */
    public function addToSegmentBookingClass($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The segmentBookingClass property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->segmentBookingClass[] = $item;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\BundledService
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BundledService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
