<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingClassAvails StructType
 * Meta informations extracted from the WSDL
 * - documentation: A collection of availability counts per booking class.
 * @subpackage Structs
 */
class BookingClassAvails extends AbstractStructBase
{
    /**
     * The BookingClassAvail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 26
     * @var \StructType\BookingClassAvail[]
     */
    public $BookingClassAvail;
    /**
     * Constructor method for BookingClassAvails
     * @uses BookingClassAvails::setBookingClassAvail()
     * @param \StructType\BookingClassAvail[] $bookingClassAvail
     */
    public function __construct(array $bookingClassAvail = array())
    {
        $this
            ->setBookingClassAvail($bookingClassAvail);
    }
    /**
     * Get BookingClassAvail value
     * @return \StructType\BookingClassAvail[]|null
     */
    public function getBookingClassAvail()
    {
        return $this->BookingClassAvail;
    }
    /**
     * Set BookingClassAvail value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingClassAvail[] $bookingClassAvail
     * @return \StructType\BookingClassAvails
     */
    public function setBookingClassAvail(array $bookingClassAvail = array())
    {
        foreach ($bookingClassAvail as $bookingClassAvailsBookingClassAvailItem) {
            // validation for constraint: itemType
            if (!$bookingClassAvailsBookingClassAvailItem instanceof \StructType\BookingClassAvail) {
                throw new \InvalidArgumentException(sprintf('The BookingClassAvail property can only contain items of \StructType\BookingClassAvail, "%s" given', is_object($bookingClassAvailsBookingClassAvailItem) ? get_class($bookingClassAvailsBookingClassAvailItem) : gettype($bookingClassAvailsBookingClassAvailItem)), __LINE__);
            }
        }
        $this->BookingClassAvail = $bookingClassAvail;
        return $this;
    }
    /**
     * Add item to BookingClassAvail value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingClassAvail $item
     * @return \StructType\BookingClassAvails
     */
    public function addToBookingClassAvail(\StructType\BookingClassAvail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingClassAvail) {
            throw new \InvalidArgumentException(sprintf('The BookingClassAvail property can only contain items of \StructType\BookingClassAvail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingClassAvail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingClassAvails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
