<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Beneficiary StructType
 * Meta informations extracted from the WSDL
 * - documentation: Unique identifying code for beneficiary e.g. Social Security Number.
 * @subpackage Structs
 */
class Beneficiary extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Address;
    /**
     * The Relation
     * @var string
     */
    public $Relation;
    /**
     * The BenefitPercent
     * @var string
     */
    public $BenefitPercent;
    /**
     * Constructor method for Beneficiary
     * @uses Beneficiary::setName()
     * @uses Beneficiary::setAddress()
     * @uses Beneficiary::setRelation()
     * @uses Beneficiary::setBenefitPercent()
     * @param string $name
     * @param mixed $address
     * @param string $relation
     * @param string $benefitPercent
     */
    public function __construct($name = null, $address = null, $relation = null, $benefitPercent = null)
    {
        $this
            ->setName($name)
            ->setAddress($address)
            ->setRelation($relation)
            ->setBenefitPercent($benefitPercent);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @uses \EnumType\Name::valueIsValid()
     * @uses \EnumType\Name::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $name
     * @return \StructType\Beneficiary
     */
    public function setName($name = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Name::valueIsValid($name)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $name, implode(', ', \EnumType\Name::getValidValues())), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return mixed|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param mixed $address
     * @return \StructType\Beneficiary
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Relation value
     * @return string|null
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * Set Relation value
     * @param string $relation
     * @return \StructType\Beneficiary
     */
    public function setRelation($relation = null)
    {
        // validation for constraint: string
        if (!is_null($relation) && !is_string($relation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relation)), __LINE__);
        }
        $this->Relation = $relation;
        return $this;
    }
    /**
     * Get BenefitPercent value
     * @return string|null
     */
    public function getBenefitPercent()
    {
        return $this->BenefitPercent;
    }
    /**
     * Set BenefitPercent value
     * @param string $benefitPercent
     * @return \StructType\Beneficiary
     */
    public function setBenefitPercent($benefitPercent = null)
    {
        // validation for constraint: string
        if (!is_null($benefitPercent) && !is_string($benefitPercent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($benefitPercent)), __LINE__);
        }
        $this->BenefitPercent = $benefitPercent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Beneficiary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
