<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageDetailsResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: One BaggageDetailsResponse element is returned for each of the flight segment requested in the input request.
 * @subpackage Structs
 */
class BaggageDetailsResponse extends AbstractStructBase
{
    /**
     * The FlightSegmentInfo
     * @var \StructType\FlightSegmentInfo
     */
    public $FlightSegmentInfo;
    /**
     * The Baggage
     * Meta informations extracted from the WSDL
     * - documentation: This identifies the baggage details for the flight segment in the corresponding 'FlightSegmentInfo' element.
     * - maxOccurs: 99
     * @var \StructType\Baggage[]
     */
    public $Baggage;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: This is used for PNR record locator. If there are more than one PNR numbers because of muliple airlines in the itinerary then this element could be repeated.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $BookingReferenceID;
    /**
     * Constructor method for BaggageDetailsResponse
     * @uses BaggageDetailsResponse::setFlightSegmentInfo()
     * @uses BaggageDetailsResponse::setBaggage()
     * @uses BaggageDetailsResponse::setBookingReferenceID()
     * @param \StructType\FlightSegmentInfo $flightSegmentInfo
     * @param \StructType\Baggage[] $baggage
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     */
    public function __construct(\StructType\FlightSegmentInfo $flightSegmentInfo = null, array $baggage = array(), array $bookingReferenceID = array())
    {
        $this
            ->setFlightSegmentInfo($flightSegmentInfo)
            ->setBaggage($baggage)
            ->setBookingReferenceID($bookingReferenceID);
    }
    /**
     * Get FlightSegmentInfo value
     * @return \StructType\FlightSegmentInfo|null
     */
    public function getFlightSegmentInfo()
    {
        return $this->FlightSegmentInfo;
    }
    /**
     * Set FlightSegmentInfo value
     * @param \StructType\FlightSegmentInfo $flightSegmentInfo
     * @return \StructType\BaggageDetailsResponse
     */
    public function setFlightSegmentInfo(\StructType\FlightSegmentInfo $flightSegmentInfo = null)
    {
        $this->FlightSegmentInfo = $flightSegmentInfo;
        return $this;
    }
    /**
     * Get Baggage value
     * @return \StructType\Baggage[]|null
     */
    public function getBaggage()
    {
        return $this->Baggage;
    }
    /**
     * Set Baggage value
     * @throws \InvalidArgumentException
     * @param \StructType\Baggage[] $baggage
     * @return \StructType\BaggageDetailsResponse
     */
    public function setBaggage(array $baggage = array())
    {
        foreach ($baggage as $baggageDetailsResponseBaggageItem) {
            // validation for constraint: itemType
            if (!$baggageDetailsResponseBaggageItem instanceof \StructType\Baggage) {
                throw new \InvalidArgumentException(sprintf('The Baggage property can only contain items of \StructType\Baggage, "%s" given', is_object($baggageDetailsResponseBaggageItem) ? get_class($baggageDetailsResponseBaggageItem) : gettype($baggageDetailsResponseBaggageItem)), __LINE__);
            }
        }
        $this->Baggage = $baggage;
        return $this;
    }
    /**
     * Add item to Baggage value
     * @throws \InvalidArgumentException
     * @param \StructType\Baggage $item
     * @return \StructType\BaggageDetailsResponse
     */
    public function addToBaggage(\StructType\Baggage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Baggage) {
            throw new \InvalidArgumentException(sprintf('The Baggage property can only contain items of \StructType\Baggage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Baggage[] = $item;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     * @return \StructType\BaggageDetailsResponse
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        foreach ($bookingReferenceID as $baggageDetailsResponseBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$baggageDetailsResponseBookingReferenceIDItem instanceof \StructType\UniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($baggageDetailsResponseBookingReferenceIDItem) ? get_class($baggageDetailsResponseBookingReferenceIDItem) : gettype($baggageDetailsResponseBookingReferenceIDItem)), __LINE__);
            }
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\BaggageDetailsResponse
     */
    public function addToBookingReferenceID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaggageDetailsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
