<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailableFlexiFares StructType
 * Meta informations extracted from the WSDL
 * - documentation: Avalaible Flexi Fares for the reservation
 * @subpackage Structs
 */
class AvailableFlexiFares extends AbstractStructBase
{
    /**
     * The InBoundFlexiAvailable
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that an inbound flexi fare is available.
     * - use: required
     * @var bool
     */
    public $InBoundFlexiAvailable;
    /**
     * The OutBoundFlexiAvailable
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that an outbound flexi fare is available.
     * - use: required
     * @var bool
     */
    public $OutBoundFlexiAvailable;
    /**
     * The FlexiFare
     * Meta informations extracted from the WSDL
     * - documentation: Flexible Fare Information.
     * - maxOccurs: 2
     * @var mixed[]
     */
    public $FlexiFare;
    /**
     * Constructor method for AvailableFlexiFares
     * @uses AvailableFlexiFares::setInBoundFlexiAvailable()
     * @uses AvailableFlexiFares::setOutBoundFlexiAvailable()
     * @uses AvailableFlexiFares::setFlexiFare()
     * @param bool $inBoundFlexiAvailable
     * @param bool $outBoundFlexiAvailable
     * @param mixed[] $flexiFare
     */
    public function __construct($inBoundFlexiAvailable = null, $outBoundFlexiAvailable = null, array $flexiFare = array())
    {
        $this
            ->setInBoundFlexiAvailable($inBoundFlexiAvailable)
            ->setOutBoundFlexiAvailable($outBoundFlexiAvailable)
            ->setFlexiFare($flexiFare);
    }
    /**
     * Get InBoundFlexiAvailable value
     * @return bool
     */
    public function getInBoundFlexiAvailable()
    {
        return $this->InBoundFlexiAvailable;
    }
    /**
     * Set InBoundFlexiAvailable value
     * @param bool $inBoundFlexiAvailable
     * @return \StructType\AvailableFlexiFares
     */
    public function setInBoundFlexiAvailable($inBoundFlexiAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($inBoundFlexiAvailable) && !is_bool($inBoundFlexiAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inBoundFlexiAvailable)), __LINE__);
        }
        $this->InBoundFlexiAvailable = $inBoundFlexiAvailable;
        return $this;
    }
    /**
     * Get OutBoundFlexiAvailable value
     * @return bool
     */
    public function getOutBoundFlexiAvailable()
    {
        return $this->OutBoundFlexiAvailable;
    }
    /**
     * Set OutBoundFlexiAvailable value
     * @param bool $outBoundFlexiAvailable
     * @return \StructType\AvailableFlexiFares
     */
    public function setOutBoundFlexiAvailable($outBoundFlexiAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($outBoundFlexiAvailable) && !is_bool($outBoundFlexiAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($outBoundFlexiAvailable)), __LINE__);
        }
        $this->OutBoundFlexiAvailable = $outBoundFlexiAvailable;
        return $this;
    }
    /**
     * Get FlexiFare value
     * @return mixed[]|null
     */
    public function getFlexiFare()
    {
        return $this->FlexiFare;
    }
    /**
     * Set FlexiFare value
     * @throws \InvalidArgumentException
     * @param mixed[] $flexiFare
     * @return \StructType\AvailableFlexiFares
     */
    public function setFlexiFare(array $flexiFare = array())
    {
        foreach ($flexiFare as $availableFlexiFaresFlexiFareItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The FlexiFare property can only contain items of anyType, "%s" given', is_object($availableFlexiFaresFlexiFareItem) ? get_class($availableFlexiFaresFlexiFareItem) : gettype($availableFlexiFaresFlexiFareItem)), __LINE__);
            }
        }
        $this->FlexiFare = $flexiFare;
        return $this;
    }
    /**
     * Add item to FlexiFare value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AvailableFlexiFares
     */
    public function addToFlexiFare($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The FlexiFare property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlexiFare[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailableFlexiFares
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
