<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrivalDateTime StructType
 * Meta informations extracted from the WSDL
 * - documentation: Specifies scheduled and other date time information.
 * - type: xs:dateTime
 * - use: optional
 * @subpackage Structs
 */
class ArrivalDateTime extends AbstractStructBase
{
    /**
     * The Scheduled
     * Meta informations extracted from the WSDL
     * - documentation: Scheduled arrival date/time for flight leg. | Allows for the specification of a date time or just time.
     * - union: dateTime | time
     * @var string
     */
    public $Scheduled;
    /**
     * The Estimated
     * Meta informations extracted from the WSDL
     * - documentation: Estimated arrival date/time for flight leg. | Allows for the specification of a date time or just time.
     * - union: dateTime | time
     * @var string
     */
    public $Estimated;
    /**
     * The Actual
     * Meta informations extracted from the WSDL
     * - documentation: Actual operational arrival date/time for flight leg. | Allows for the specification of a date time or just time.
     * - union: dateTime | time
     * @var string
     */
    public $Actual;
    /**
     * The ReasonCode
     * Meta informations extracted from the WSDL
     * - documentation: The reason attributed to a delay or cancellation. Refers to OTA Code Table FDC. | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - use: optional
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $ReasonCode;
    /**
     * Constructor method for ArrivalDateTime
     * @uses ArrivalDateTime::setScheduled()
     * @uses ArrivalDateTime::setEstimated()
     * @uses ArrivalDateTime::setActual()
     * @uses ArrivalDateTime::setReasonCode()
     * @param string $scheduled
     * @param string $estimated
     * @param string $actual
     * @param string $reasonCode
     */
    public function __construct($scheduled = null, $estimated = null, $actual = null, $reasonCode = null)
    {
        $this
            ->setScheduled($scheduled)
            ->setEstimated($estimated)
            ->setActual($actual)
            ->setReasonCode($reasonCode);
    }
    /**
     * Get Scheduled value
     * @return string|null
     */
    public function getScheduled()
    {
        return $this->Scheduled;
    }
    /**
     * Set Scheduled value
     * @param string $scheduled
     * @return \StructType\ArrivalDateTime
     */
    public function setScheduled($scheduled = null)
    {
        // validation for constraint: string
        if (!is_null($scheduled) && !is_string($scheduled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduled)), __LINE__);
        }
        $this->Scheduled = $scheduled;
        return $this;
    }
    /**
     * Get Estimated value
     * @return string|null
     */
    public function getEstimated()
    {
        return $this->Estimated;
    }
    /**
     * Set Estimated value
     * @param string $estimated
     * @return \StructType\ArrivalDateTime
     */
    public function setEstimated($estimated = null)
    {
        // validation for constraint: string
        if (!is_null($estimated) && !is_string($estimated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimated)), __LINE__);
        }
        $this->Estimated = $estimated;
        return $this;
    }
    /**
     * Get Actual value
     * @return string|null
     */
    public function getActual()
    {
        return $this->Actual;
    }
    /**
     * Set Actual value
     * @param string $actual
     * @return \StructType\ArrivalDateTime
     */
    public function setActual($actual = null)
    {
        // validation for constraint: string
        if (!is_null($actual) && !is_string($actual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actual)), __LINE__);
        }
        $this->Actual = $actual;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \StructType\ArrivalDateTime
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($reasonCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}", "%s" given', var_export($reasonCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArrivalDateTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
