<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrivalAirport StructType
 * Meta informations extracted from the WSDL
 * - documentation: Arrival point of flight segment. Second occurrence indicates diversion airport. | Arrival point of flight segment.
 * @subpackage Structs
 */
class ArrivalAirport extends AbstractStructBase
{
    /**
     * The Diversion
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the flight has diverted to this airport.
     * - use: required
     * @var bool
     */
    public $Diversion;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Any special comments about the arrival airport.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FreeTextType[]
     */
    public $Comment;
    /**
     * The BaggageClaim
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the location or carousel number for baggage from the arriving flight. | Used for Character Strings, length 1 to 8
     * - use: optional
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $BaggageClaim;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: Location code used to identify a specific airport. | Code used to identify a location.
     * @var string
     */
    public $LocationCode;
    /**
     * The CodeContext
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the context of the identifying code, such as IATA, ARC, or internal code, etc. | Identifies the context of the identifying code (e.g., IATA, ARC, or internal code).
     * @var string
     */
    public $CodeContext;
    /**
     * The Terminal
     * Meta informations extracted from the WSDL
     * - documentation: Arrival or departure terminal (e.g., Concourse A)
     * @var string
     */
    public $Terminal;
    /**
     * The Gate
     * Meta informations extracted from the WSDL
     * - documentation: Arrival or departure gate (e.g., B12)
     * @var string
     */
    public $Gate;
    /**
     * Constructor method for ArrivalAirport
     * @uses ArrivalAirport::setDiversion()
     * @uses ArrivalAirport::setComment()
     * @uses ArrivalAirport::setBaggageClaim()
     * @uses ArrivalAirport::setLocationCode()
     * @uses ArrivalAirport::setCodeContext()
     * @uses ArrivalAirport::setTerminal()
     * @uses ArrivalAirport::setGate()
     * @param bool $diversion
     * @param \StructType\FreeTextType[] $comment
     * @param string $baggageClaim
     * @param string $locationCode
     * @param string $codeContext
     * @param string $terminal
     * @param string $gate
     */
    public function __construct($diversion = null, array $comment = array(), $baggageClaim = null, $locationCode = null, $codeContext = null, $terminal = null, $gate = null)
    {
        $this
            ->setDiversion($diversion)
            ->setComment($comment)
            ->setBaggageClaim($baggageClaim)
            ->setLocationCode($locationCode)
            ->setCodeContext($codeContext)
            ->setTerminal($terminal)
            ->setGate($gate);
    }
    /**
     * Get Diversion value
     * @return bool
     */
    public function getDiversion()
    {
        return $this->Diversion;
    }
    /**
     * Set Diversion value
     * @param bool $diversion
     * @return \StructType\ArrivalAirport
     */
    public function setDiversion($diversion = null)
    {
        // validation for constraint: boolean
        if (!is_null($diversion) && !is_bool($diversion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($diversion)), __LINE__);
        }
        $this->Diversion = $diversion;
        return $this;
    }
    /**
     * Get Comment value
     * @return \StructType\FreeTextType[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType[] $comment
     * @return \StructType\ArrivalAirport
     */
    public function setComment(array $comment = array())
    {
        foreach ($comment as $arrivalAirportCommentItem) {
            // validation for constraint: itemType
            if (!$arrivalAirportCommentItem instanceof \StructType\FreeTextType) {
                throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \StructType\FreeTextType, "%s" given', is_object($arrivalAirportCommentItem) ? get_class($arrivalAirportCommentItem) : gettype($arrivalAirportCommentItem)), __LINE__);
            }
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType $item
     * @return \StructType\ArrivalAirport
     */
    public function addToComment(\StructType\FreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FreeTextType) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \StructType\FreeTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get BaggageClaim value
     * @return string|null
     */
    public function getBaggageClaim()
    {
        return $this->BaggageClaim;
    }
    /**
     * Set BaggageClaim value
     * @param string $baggageClaim
     * @return \StructType\ArrivalAirport
     */
    public function setBaggageClaim($baggageClaim = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($baggageClaim) && strlen($baggageClaim) > 8) || (is_array($baggageClaim) && count($baggageClaim) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($baggageClaim) ? strlen($baggageClaim) : count($baggageClaim)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($baggageClaim) && strlen($baggageClaim) < 1) || (is_array($baggageClaim) && count($baggageClaim) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($baggageClaim) && !is_string($baggageClaim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baggageClaim)), __LINE__);
        }
        $this->BaggageClaim = $baggageClaim;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \StructType\ArrivalAirport
     */
    public function setLocationCode($locationCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCode) && !is_string($locationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationCode)), __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\ArrivalAirport
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \StructType\ArrivalAirport
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: string
        if (!is_null($terminal) && !is_string($terminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminal)), __LINE__);
        }
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Get Gate value
     * @return string|null
     */
    public function getGate()
    {
        return $this->Gate;
    }
    /**
     * Set Gate value
     * @param string $gate
     * @return \StructType\ArrivalAirport
     */
    public function setGate($gate = null)
    {
        // validation for constraint: string
        if (!is_null($gate) && !is_string($gate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gate)), __LINE__);
        }
        $this->Gate = $gate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArrivalAirport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
