<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTaxType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the data fields available for air tax. The element text of this type may contain a description of the tax. | A textual description.
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class AirTaxType extends AbstractStructBase
{
    /**
     * The TaxCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the code for the tax.
     * - use: required
     * @var string
     */
    public $TaxCode;
    /**
     * The TaxCountry
     * Meta informations extracted from the WSDL
     * - documentation: Used to identify the country imposing the tax.
     * - use: optional
     * @var string
     */
    public $TaxCountry;
    /**
     * The TaxName
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the tax code by name.
     * - use: optional
     * @var string
     */
    public $TaxName;
    /**
     * Constructor method for AirTaxType
     * @uses AirTaxType::setTaxCode()
     * @uses AirTaxType::setTaxCountry()
     * @uses AirTaxType::setTaxName()
     * @param string $taxCode
     * @param string $taxCountry
     * @param string $taxName
     */
    public function __construct($taxCode = null, $taxCountry = null, $taxName = null)
    {
        $this
            ->setTaxCode($taxCode)
            ->setTaxCountry($taxCountry)
            ->setTaxName($taxName);
    }
    /**
     * Get TaxCode value
     * @return string
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \StructType\AirTaxType
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get TaxCountry value
     * @return string|null
     */
    public function getTaxCountry()
    {
        return $this->TaxCountry;
    }
    /**
     * Set TaxCountry value
     * @param string $taxCountry
     * @return \StructType\AirTaxType
     */
    public function setTaxCountry($taxCountry = null)
    {
        // validation for constraint: string
        if (!is_null($taxCountry) && !is_string($taxCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxCountry)), __LINE__);
        }
        $this->TaxCountry = $taxCountry;
        return $this;
    }
    /**
     * Get TaxName value
     * @return string|null
     */
    public function getTaxName()
    {
        return $this->TaxName;
    }
    /**
     * Set TaxName value
     * @param string $taxName
     * @return \StructType\AirTaxType
     */
    public function setTaxName($taxName = null)
    {
        // validation for constraint: string
        if (!is_null($taxName) && !is_string($taxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxName)), __LINE__);
        }
        $this->TaxName = $taxName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirTaxType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
