<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirReservation StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains all booking response information pertaining to a completed reservation. | One line in a list of airline reservations. It may contain the PNR locator, flight segment information, traveler name, and itinerary name.
 * @subpackage Structs
 */
class AirReservation extends AirReservationType
{
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - documentation: The airline code, flight number, departure and arrival dates, and the origin and destination.
     * - minOccurs: 0
     * @var \StructType\FlightSegmentType
     */
    public $FlightSegment;
    /**
     * The TravelerName
     * Meta informations extracted from the WSDL
     * - documentation: The names of travelers (up to five) in the reservation.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\PersonNameType[]
     */
    public $TravelerName;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: The reservation id number, PNR locator.
     * @var string
     */
    public $BookingReferenceID;
    /**
     * The DateBooked
     * Meta informations extracted from the WSDL
     * - documentation: Date of the creation of this reservation.
     * - use: optional
     * @var string
     */
    public $DateBooked;
    /**
     * The ItineraryName
     * Meta informations extracted from the WSDL
     * - documentation: A name given to this itinerary. | Used for Character Strings, length 0 to 64
     * - use: optional
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $ItineraryName;
    /**
     * Constructor method for AirReservation
     * @uses AirReservation::setFlightSegment()
     * @uses AirReservation::setTravelerName()
     * @uses AirReservation::setTPA_Extensions()
     * @uses AirReservation::setBookingReferenceID()
     * @uses AirReservation::setDateBooked()
     * @uses AirReservation::setItineraryName()
     * @param \StructType\FlightSegmentType $flightSegment
     * @param \StructType\PersonNameType[] $travelerName
     * @param mixed $tPA_Extensions
     * @param string $bookingReferenceID
     * @param string $dateBooked
     * @param string $itineraryName
     */
    public function __construct(\StructType\FlightSegmentType $flightSegment = null, array $travelerName = array(), $tPA_Extensions = null, $bookingReferenceID = null, $dateBooked = null, $itineraryName = null)
    {
        $this
            ->setFlightSegment($flightSegment)
            ->setTravelerName($travelerName)
            ->setTPA_Extensions($tPA_Extensions)
            ->setBookingReferenceID($bookingReferenceID)
            ->setDateBooked($dateBooked)
            ->setItineraryName($itineraryName);
    }
    /**
     * Get FlightSegment value
     * @return \StructType\FlightSegmentType|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @param \StructType\FlightSegmentType $flightSegment
     * @return \StructType\AirReservation
     */
    public function setFlightSegment(\StructType\FlightSegmentType $flightSegment = null)
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Get TravelerName value
     * @return \StructType\PersonNameType[]|null
     */
    public function getTravelerName()
    {
        return $this->TravelerName;
    }
    /**
     * Set TravelerName value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonNameType[] $travelerName
     * @return \StructType\AirReservation
     */
    public function setTravelerName(array $travelerName = array())
    {
        foreach ($travelerName as $airReservationTravelerNameItem) {
            // validation for constraint: itemType
            if (!$airReservationTravelerNameItem instanceof \StructType\PersonNameType) {
                throw new \InvalidArgumentException(sprintf('The TravelerName property can only contain items of \StructType\PersonNameType, "%s" given', is_object($airReservationTravelerNameItem) ? get_class($airReservationTravelerNameItem) : gettype($airReservationTravelerNameItem)), __LINE__);
            }
        }
        $this->TravelerName = $travelerName;
        return $this;
    }
    /**
     * Add item to TravelerName value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonNameType $item
     * @return \StructType\AirReservation
     */
    public function addToTravelerName(\StructType\PersonNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonNameType) {
            throw new \InvalidArgumentException(sprintf('The TravelerName property can only contain items of \StructType\PersonNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelerName[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AirReservation
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return string|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param string $bookingReferenceID
     * @return \StructType\AirReservation
     */
    public function setBookingReferenceID($bookingReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReferenceID) && !is_string($bookingReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get DateBooked value
     * @return string|null
     */
    public function getDateBooked()
    {
        return $this->DateBooked;
    }
    /**
     * Set DateBooked value
     * @param string $dateBooked
     * @return \StructType\AirReservation
     */
    public function setDateBooked($dateBooked = null)
    {
        // validation for constraint: string
        if (!is_null($dateBooked) && !is_string($dateBooked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateBooked)), __LINE__);
        }
        $this->DateBooked = $dateBooked;
        return $this;
    }
    /**
     * Get ItineraryName value
     * @return string|null
     */
    public function getItineraryName()
    {
        return $this->ItineraryName;
    }
    /**
     * Set ItineraryName value
     * @param string $itineraryName
     * @return \StructType\AirReservation
     */
    public function setItineraryName($itineraryName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($itineraryName) && strlen($itineraryName) > 64) || (is_array($itineraryName) && count($itineraryName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($itineraryName) ? strlen($itineraryName) : count($itineraryName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($itineraryName) && strlen($itineraryName) < 0) || (is_array($itineraryName) && count($itineraryName) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($itineraryName) && !is_string($itineraryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itineraryName)), __LINE__);
        }
        $this->ItineraryName = $itineraryName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
