<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activities StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for any number of activities that traveler(s) will engage in while on their journey.
 * @subpackage Structs
 */
class Activities extends AbstractStructBase
{
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - documentation: Identifies a single Activity that traveler(s) will engage in while on their journey.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $Activity;
    /**
     * Constructor method for Activities
     * @uses Activities::setActivity()
     * @param mixed[] $activity
     */
    public function __construct(array $activity = array())
    {
        $this
            ->setActivity($activity);
    }
    /**
     * Get Activity value
     * @return mixed[]|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @throws \InvalidArgumentException
     * @param mixed[] $activity
     * @return \StructType\Activities
     */
    public function setActivity(array $activity = array())
    {
        foreach ($activity as $activitiesActivityItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of anyType, "%s" given', is_object($activitiesActivityItem) ? get_class($activitiesActivityItem) : gettype($activitiesActivityItem)), __LINE__);
            }
        }
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Add item to Activity value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Activities
     */
    public function addToActivity($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Activity[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Activities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
