<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AA_OTA_TransactionsReconRQ StructType
 * Meta informations extracted from the WSDL
 * - documentation: External transactions reconciliation request.
 * @subpackage Structs
 */
class AA_OTA_TransactionsReconRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - documentation: Point of sale object.
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The startTimestamp
     * @var string
     */
    public $startTimestamp;
    /**
     * The endTimestamp
     * @var string
     */
    public $endTimestamp;
    /**
     * The PNRPaymentTransactions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AAPNRPaymentTransactionType[]
     */
    public $PNRPaymentTransactions;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for AA_OTA_TransactionsReconRQ
     * @uses AA_OTA_TransactionsReconRQ::setPOS()
     * @uses AA_OTA_TransactionsReconRQ::setStartTimestamp()
     * @uses AA_OTA_TransactionsReconRQ::setEndTimestamp()
     * @uses AA_OTA_TransactionsReconRQ::setPNRPaymentTransactions()
     * @uses AA_OTA_TransactionsReconRQ::setEchoToken()
     * @uses AA_OTA_TransactionsReconRQ::setTimeStamp()
     * @uses AA_OTA_TransactionsReconRQ::setTarget()
     * @uses AA_OTA_TransactionsReconRQ::setVersion()
     * @uses AA_OTA_TransactionsReconRQ::setTransactionIdentifier()
     * @uses AA_OTA_TransactionsReconRQ::setSequenceNmbr()
     * @uses AA_OTA_TransactionsReconRQ::setTransactionStatusCode()
     * @uses AA_OTA_TransactionsReconRQ::setRetransmissionIndicator()
     * @param \StructType\POS_Type $pOS
     * @param string $startTimestamp
     * @param string $endTimestamp
     * @param \StructType\AAPNRPaymentTransactionType[] $pNRPaymentTransactions
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct(\StructType\POS_Type $pOS = null, $startTimestamp = null, $endTimestamp = null, array $pNRPaymentTransactions = array(), $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setPOS($pOS)
            ->setStartTimestamp($startTimestamp)
            ->setEndTimestamp($endTimestamp)
            ->setPNRPaymentTransactions($pNRPaymentTransactions)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get startTimestamp value
     * @return string|null
     */
    public function getStartTimestamp()
    {
        return $this->startTimestamp;
    }
    /**
     * Set startTimestamp value
     * @param string $startTimestamp
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setStartTimestamp($startTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($startTimestamp) && !is_string($startTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTimestamp)), __LINE__);
        }
        $this->startTimestamp = $startTimestamp;
        return $this;
    }
    /**
     * Get endTimestamp value
     * @return string|null
     */
    public function getEndTimestamp()
    {
        return $this->endTimestamp;
    }
    /**
     * Set endTimestamp value
     * @param string $endTimestamp
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setEndTimestamp($endTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($endTimestamp) && !is_string($endTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTimestamp)), __LINE__);
        }
        $this->endTimestamp = $endTimestamp;
        return $this;
    }
    /**
     * Get PNRPaymentTransactions value
     * @return \StructType\AAPNRPaymentTransactionType[]|null
     */
    public function getPNRPaymentTransactions()
    {
        return $this->PNRPaymentTransactions;
    }
    /**
     * Set PNRPaymentTransactions value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPNRPaymentTransactionType[] $pNRPaymentTransactions
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setPNRPaymentTransactions(array $pNRPaymentTransactions = array())
    {
        foreach ($pNRPaymentTransactions as $aA_OTA_TransactionsReconRQPNRPaymentTransactionsItem) {
            // validation for constraint: itemType
            if (!$aA_OTA_TransactionsReconRQPNRPaymentTransactionsItem instanceof \StructType\AAPNRPaymentTransactionType) {
                throw new \InvalidArgumentException(sprintf('The PNRPaymentTransactions property can only contain items of \StructType\AAPNRPaymentTransactionType, "%s" given', is_object($aA_OTA_TransactionsReconRQPNRPaymentTransactionsItem) ? get_class($aA_OTA_TransactionsReconRQPNRPaymentTransactionsItem) : gettype($aA_OTA_TransactionsReconRQPNRPaymentTransactionsItem)), __LINE__);
            }
        }
        $this->PNRPaymentTransactions = $pNRPaymentTransactions;
        return $this;
    }
    /**
     * Add item to PNRPaymentTransactions value
     * @throws \InvalidArgumentException
     * @param \StructType\AAPNRPaymentTransactionType $item
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function addToPNRPaymentTransactions(\StructType\AAPNRPaymentTransactionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AAPNRPaymentTransactionType) {
            throw new \InvalidArgumentException(sprintf('The PNRPaymentTransactions property can only contain items of \StructType\AAPNRPaymentTransactionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PNRPaymentTransactions[] = $item;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AA_OTA_TransactionsReconRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
