<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AATravelerCnxModAddResBalancesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Traveler balances for reservation modification with respect to the overall reservation (total charges before modification, total charges after modification, total payment, total balance to pay)
 * @subpackage Structs
 */
class AATravelerCnxModAddResBalancesType extends AbstractStructBase
{
    /**
     * The TravelerRefNumberRPH
     * @var string
     */
    public $TravelerRefNumberRPH;
    /**
     * The CurrentTotalCharges
     * @var \StructType\AACurrencyAmountType
     */
    public $CurrentTotalCharges;
    /**
     * The NewTotalCharges
     * @var \StructType\AACurrencyAmountType
     */
    public $NewTotalCharges;
    /**
     * The CurrentTotalPayments
     * @var \StructType\AACurrencyAmountType
     */
    public $CurrentTotalPayments;
    /**
     * The Balance
     * @var \StructType\AACurrencyAmountType
     */
    public $Balance;
    /**
     * Constructor method for AATravelerCnxModAddResBalancesType
     * @uses AATravelerCnxModAddResBalancesType::setTravelerRefNumberRPH()
     * @uses AATravelerCnxModAddResBalancesType::setCurrentTotalCharges()
     * @uses AATravelerCnxModAddResBalancesType::setNewTotalCharges()
     * @uses AATravelerCnxModAddResBalancesType::setCurrentTotalPayments()
     * @uses AATravelerCnxModAddResBalancesType::setBalance()
     * @param string $travelerRefNumberRPH
     * @param \StructType\AACurrencyAmountType $currentTotalCharges
     * @param \StructType\AACurrencyAmountType $newTotalCharges
     * @param \StructType\AACurrencyAmountType $currentTotalPayments
     * @param \StructType\AACurrencyAmountType $balance
     */
    public function __construct($travelerRefNumberRPH = null, \StructType\AACurrencyAmountType $currentTotalCharges = null, \StructType\AACurrencyAmountType $newTotalCharges = null, \StructType\AACurrencyAmountType $currentTotalPayments = null, \StructType\AACurrencyAmountType $balance = null)
    {
        $this
            ->setTravelerRefNumberRPH($travelerRefNumberRPH)
            ->setCurrentTotalCharges($currentTotalCharges)
            ->setNewTotalCharges($newTotalCharges)
            ->setCurrentTotalPayments($currentTotalPayments)
            ->setBalance($balance);
    }
    /**
     * Get TravelerRefNumberRPH value
     * @return string|null
     */
    public function getTravelerRefNumberRPH()
    {
        return $this->TravelerRefNumberRPH;
    }
    /**
     * Set TravelerRefNumberRPH value
     * @param string $travelerRefNumberRPH
     * @return \StructType\AATravelerCnxModAddResBalancesType
     */
    public function setTravelerRefNumberRPH($travelerRefNumberRPH = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRefNumberRPH) && !is_string($travelerRefNumberRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelerRefNumberRPH)), __LINE__);
        }
        $this->TravelerRefNumberRPH = $travelerRefNumberRPH;
        return $this;
    }
    /**
     * Get CurrentTotalCharges value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getCurrentTotalCharges()
    {
        return $this->CurrentTotalCharges;
    }
    /**
     * Set CurrentTotalCharges value
     * @param \StructType\AACurrencyAmountType $currentTotalCharges
     * @return \StructType\AATravelerCnxModAddResBalancesType
     */
    public function setCurrentTotalCharges(\StructType\AACurrencyAmountType $currentTotalCharges = null)
    {
        $this->CurrentTotalCharges = $currentTotalCharges;
        return $this;
    }
    /**
     * Get NewTotalCharges value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getNewTotalCharges()
    {
        return $this->NewTotalCharges;
    }
    /**
     * Set NewTotalCharges value
     * @param \StructType\AACurrencyAmountType $newTotalCharges
     * @return \StructType\AATravelerCnxModAddResBalancesType
     */
    public function setNewTotalCharges(\StructType\AACurrencyAmountType $newTotalCharges = null)
    {
        $this->NewTotalCharges = $newTotalCharges;
        return $this;
    }
    /**
     * Get CurrentTotalPayments value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getCurrentTotalPayments()
    {
        return $this->CurrentTotalPayments;
    }
    /**
     * Set CurrentTotalPayments value
     * @param \StructType\AACurrencyAmountType $currentTotalPayments
     * @return \StructType\AATravelerCnxModAddResBalancesType
     */
    public function setCurrentTotalPayments(\StructType\AACurrencyAmountType $currentTotalPayments = null)
    {
        $this->CurrentTotalPayments = $currentTotalPayments;
        return $this;
    }
    /**
     * Get Balance value
     * @return \StructType\AACurrencyAmountType|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param \StructType\AACurrencyAmountType $balance
     * @return \StructType\AATravelerCnxModAddResBalancesType
     */
    public function setBalance(\StructType\AACurrencyAmountType $balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AATravelerCnxModAddResBalancesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
