<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AATaxType StructType
 * @subpackage Structs
 */
class AATaxType extends AbstractStructBase
{
    /**
     * The taxCode
     * @var string
     */
    public $taxCode;
    /**
     * The taxName
     * @var string
     */
    public $taxName;
    /**
     * Constructor method for AATaxType
     * @uses AATaxType::setTaxCode()
     * @uses AATaxType::setTaxName()
     * @param string $taxCode
     * @param string $taxName
     */
    public function __construct($taxCode = null, $taxName = null)
    {
        $this
            ->setTaxCode($taxCode)
            ->setTaxName($taxName);
    }
    /**
     * Get taxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param string $taxCode
     * @return \StructType\AATaxType
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxCode)), __LINE__);
        }
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxName value
     * @return string|null
     */
    public function getTaxName()
    {
        return $this->taxName;
    }
    /**
     * Set taxName value
     * @param string $taxName
     * @return \StructType\AATaxType
     */
    public function setTaxName($taxName = null)
    {
        // validation for constraint: string
        if (!is_null($taxName) && !is_string($taxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxName)), __LINE__);
        }
        $this->taxName = $taxName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AATaxType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
